/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.MappingContainerViewIterator;
import ch.nolix.core.container.base.AbstractContainer;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.function.Function;

public final class MappingContainerView<E, T>
extends AbstractExtendedContainer<T> {
    private final IContainer<E> container;
    private final Function<E, T> mapper;

    private MappingContainerView(IContainer<E> container, Function<E, T> mapper) {
        Validator.assertThat(container).thatIsNamed("container").isNotNull();
        this.container = container;
        this.mapper = mapper;
    }

    public static <T, T2> MappingContainerView<T, T2> forContainerAndMapper(AbstractContainer<T> container, Function<T, T2> mapper) {
        return new MappingContainerView<T, T2>(container, mapper);
    }

    @Override
    public int getCount() {
        return IterableTool.getCount(this);
    }

    @Override
    public T getStoredAtOneBasedIndex(int oneBasedIndex) {
        Object element = this.container.getStoredAtOneBasedIndex(oneBasedIndex);
        return this.mapper.apply(element);
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<T> iterator() {
        return MappingContainerViewIterator.forIteratorAndMapper(this.container.iterator(), this.mapper);
    }
}

