/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.commontypetool.iteratorvalidator.IteratorValidator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.function.Predicate;

public final class FilterContainerViewIterator<E>
implements CopyableIterator<E> {
    private static final IteratorValidator ITERATOR_VALIDATOR = new IteratorValidator();
    private final CopyableIterator<E> iterator;
    private final Predicate<E> selector;
    private E optionalNextElement;

    private FilterContainerViewIterator(CopyableIterator<E> iterator, Predicate<E> selector) {
        Validator.assertThat(iterator).thatIsNamed("iterator").isNotNull();
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        this.iterator = iterator;
        this.selector = selector;
        this.moveToOptionalNextElement();
    }

    public static <T> FilterContainerViewIterator<T> forIteratorAndSelector(CopyableIterator<T> iterator, Predicate<T> selector) {
        return new FilterContainerViewIterator<T>(iterator, selector);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return FilterContainerViewIterator.forIteratorAndSelector((CopyableIterator)this.iterator.getCopy(), this.selector);
    }

    @Override
    public boolean hasNext() {
        return this.optionalNextElement != null;
    }

    @Override
    public E next() {
        ITERATOR_VALIDATOR.assertHasNext(this);
        E nextElement = this.optionalNextElement;
        this.moveToOptionalNextElement();
        return nextElement;
    }

    private void moveToOptionalNextElement() {
        this.optionalNextElement = null;
        while (this.iterator.hasNext()) {
            Object nextElement = this.iterator.next();
            if (nextElement == null || !this.selector.test(nextElement)) continue;
            this.optionalNextElement = nextElement;
            break;
        }
    }
}

