/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.errorcontrol.validator.Validator;

public final class ArrayListCapacityCalculator {
    private ArrayListCapacityCalculator() {
    }

    public static boolean arrayListNeedsToGrowForRequiredCapacity(int capacity, int requiredCapacity) {
        return requiredCapacity > capacity;
    }

    public static int calculateTargetCapacityForActualCapacityAndRequiredCapacity(int actualCapacity, int requiredCapacity) {
        Validator.assertThat(actualCapacity).thatIsNamed("actial capacity").isNotNegative();
        Validator.assertThat(requiredCapacity).thatIsNamed("required capacity").isNotNegative();
        if (actualCapacity > requiredCapacity) {
            if (actualCapacity / 3 > requiredCapacity) {
                return 2 * requiredCapacity;
            }
            return actualCapacity;
        }
        if (requiredCapacity > 1000000000) {
            return Integer.MAX_VALUE;
        }
        return ArrayListCapacityCalculator.getMax(requiredCapacity, 2 * actualCapacity);
    }

    private static int getMax(int value1, int value2) {
        if (value1 > value2) {
            return value1;
        }
        return value2;
    }
}

