/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.commontypetool.stringtool;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.commontypetool.charactertool.CharacterType;

public final class CapitalSnakeCaseTransformer {
    public String toCapitalSnakeCase(String string) {
        if (string.isEmpty()) {
            return "";
        }
        return this.toCapitalSnakeCaseWhenStringNotEmpty(string);
    }

    private String toCapitalSnakeCaseWhenStringNotEmpty(String string) {
        CharacterType firstCharacterType;
        StringBuilder stringBuilder = new StringBuilder();
        char firstCharacter = string.charAt(0);
        CharacterType previousCharacterType = firstCharacterType = this.appendFirstTargetCharacterAccordingToFirstCharacterAndGetFirstCharacterType(firstCharacter, stringBuilder);
        int i = 1;
        while (i < string.length()) {
            char character = string.charAt(i);
            CharacterType characterType = CharacterType.ofCharacter(character);
            switch (characterType) {
                case LOWER_CASE_LETTER: {
                    stringBuilder.append(Character.toUpperCase(character));
                    break;
                }
                case UPPER_CASE_LETTER: {
                    if (previousCharacterType == CharacterType.LOWER_CASE_LETTER) {
                        stringBuilder.append('_');
                    }
                    stringBuilder.append(character);
                    break;
                }
                case NUMBER: {
                    stringBuilder.append(character);
                    break;
                }
                case OTHER: {
                    stringBuilder.append(Character.toUpperCase(character));
                    break;
                }
                default: {
                    throw InvalidArgumentException.forArgument((Object)characterType);
                }
            }
            previousCharacterType = characterType;
            ++i;
        }
        return stringBuilder.toString();
    }

    private CharacterType appendFirstTargetCharacterAccordingToFirstCharacterAndGetFirstCharacterType(char firstCharacter, StringBuilder stringBuilder) {
        CharacterType firstCharacterType = CharacterType.ofCharacter(firstCharacter);
        switch (firstCharacterType) {
            case LOWER_CASE_LETTER: {
                stringBuilder.append(Character.toUpperCase(firstCharacter));
                break;
            }
            case UPPER_CASE_LETTER: {
                stringBuilder.append(firstCharacter);
                break;
            }
            case NUMBER: {
                stringBuilder.append(firstCharacter);
                break;
            }
            case OTHER: {
                if (firstCharacter == '_') break;
                stringBuilder.append(firstCharacter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)firstCharacterType);
            }
        }
        return firstCharacterType;
    }
}

