/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.commontypetool.arraytool;

import ch.nolix.core.commontypetool.arraytool.NextIndexMediator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.commontypetool.arraytool.IByteArrayMediatorWithStartIndex;
import ch.nolix.coreapi.commontypetool.arraytool.INextIndexMediator;

public final class ByteArrayMediatorWithStartIndex
implements IByteArrayMediatorWithStartIndex {
    private final byte[] byteArray;
    private int index;

    private ByteArrayMediatorWithStartIndex(byte[] byteArray, int startIndex) {
        Validator.assertThat(byteArray).thatIsNamed("byte array").isNotNull();
        Validator.assertThat(startIndex).thatIsNamed("start index").isBetween(0, byteArray.length);
        this.byteArray = byteArray;
        this.index = startIndex;
    }

    public static ByteArrayMediatorWithStartIndex forByteArrayAndStartIndex(byte[] byteArray, int startIndex) {
        return new ByteArrayMediatorWithStartIndex(byteArray, startIndex);
    }

    @Override
    public INextIndexMediator write(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.byteArray[this.index + i] = bytes[i];
            ++i;
        }
        this.index += bytes.length;
        return NextIndexMediator.forNextIndex(this.index);
    }
}

