/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.argumentcaptor.base;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentHasAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import java.util.function.Supplier;

public abstract class ArgumentCaptor<A, N> {
    private boolean hasArgument;
    private A argument;
    private final ArgumentCaptor<?, ?> nextArgumentCaptor;
    private final N nextArgumentCaptorAsNext;
    private Supplier<N> builder;

    protected ArgumentCaptor() {
        this.nextArgumentCaptor = null;
        this.nextArgumentCaptorAsNext = null;
    }

    protected ArgumentCaptor(N nextArgumentCaptor) {
        ArgumentCaptor localArgumentCaptor;
        if (!(nextArgumentCaptor instanceof ArgumentCaptor)) {
            throw InvalidArgumentException.forArgumentAndArgumentName(nextArgumentCaptor, "next argument captor");
        }
        this.nextArgumentCaptor = localArgumentCaptor = (ArgumentCaptor)nextArgumentCaptor;
        this.nextArgumentCaptorAsNext = nextArgumentCaptor;
    }

    public final N nxtArgCpt() {
        this.assertHasNextArgumentCaptor();
        return this.nextArgumentCaptorAsNext;
    }

    protected final A getStoredArgument() {
        this.assertHasArgument();
        return this.argument;
    }

    protected final N setArgumentAndGetNext(A argument) {
        this.setArgument(argument);
        return this.getNext();
    }

    protected final void setBuilder(Supplier<?> builder) {
        if (this.hasNextArgumentCaptor()) {
            this.nextArgumentCaptor.setBuilder(builder);
        } else {
            this.assertDoesNotHaveBuilder();
            Validator.assertThat(builder).thatIsNamed("builder").isNotNull();
            this.builder = builder;
        }
    }

    private void assertDoesNotHaveBuilder() {
        if (this.hasBuilder()) {
            throw ArgumentHasAttributeException.forArgumentAndAttributeName(this, "builder");
        }
    }

    private void assertHasArgument() {
        if (!this.hasArgument()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "argument");
        }
    }

    private void assertHasBuilder() {
        if (!this.hasBuilder()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "builder");
        }
    }

    private void assertHasNextArgumentCaptor() {
        if (!this.hasNextArgumentCaptor()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next argument captor");
        }
    }

    private N build() {
        return this.getStoredBuilder().get();
    }

    private N getNext() {
        if (this.hasNextArgumentCaptor()) {
            return this.nextArgumentCaptorAsNext;
        }
        return this.build();
    }

    private Supplier<N> getStoredBuilder() {
        this.assertHasBuilder();
        return this.builder;
    }

    private boolean hasArgument() {
        return this.hasArgument;
    }

    private boolean hasBuilder() {
        return this.builder != null;
    }

    private boolean hasNextArgumentCaptor() {
        return this.nextArgumentCaptor != null;
    }

    private void setArgument(A argument) {
        this.hasArgument = true;
        this.argument = argument;
    }
}

