/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.webgui.main.Layer;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.ILayerStack;
import ch.nolix.systemapi.webgui.main.IRootControlOwner;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.Optional;

public final class LayerStack
implements ILayerStack {
    private final IWebGui<?> parentGui;
    private Runnable removeLayerAction;
    private final ILinkedList<ILayer<?>> layers = LinkedList.createEmpty();

    private LayerStack(IWebGui<?> parentGui) {
        Validator.assertThat(parentGui).thatIsNamed("parent gui").isNotNull();
        this.parentGui = parentGui;
    }

    public static LayerStack forWebGui(IWebGui<?> webGui) {
        return new LayerStack(webGui);
    }

    @Override
    public boolean containsControl(IControl<?, ?> control) {
        return this.getStoredLayers().containsAny(l -> l.containsControl(control));
    }

    @Override
    public void clear() {
        while (this.containsAny()) {
            this.removeLayer(this.getStoredTopLayer());
        }
    }

    @Override
    public int getLayerCount() {
        return this.getStoredLayers().getCount();
    }

    @Override
    public Optional<IControl<?, ?>> getOptionalStoredControlByInternalId(String internalId) {
        for (ILayer iLayer : this.getStoredLayers()) {
            Optional<IControl<?, ?>> control = iLayer.getOptionalStoredControlByInternalId(internalId);
            if (!control.isPresent()) continue;
            return control;
        }
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredControls() {
        return this.getStoredLayers().toMultiples(IRootControlOwner::getStoredControls);
    }

    @Override
    public IContainer<ILayer<?>> getStoredLayers() {
        return this.layers;
    }

    @Override
    public ILayer<?> getStoredTopLayer() {
        return (ILayer)this.getStoredLayers().getStoredLast();
    }

    @Override
    public boolean hasRemoveLayerAction() {
        return this.removeLayerAction != null;
    }

    @Override
    public boolean isEmpty() {
        return this.getStoredLayers().isEmpty();
    }

    @Override
    public ILayerStack pushLayer(ILayer<?> layer) {
        layer.internalSetParentGui(this.parentGui);
        this.layers.addAtEnd(layer);
        return this;
    }

    @Override
    public ILayerStack pushLayerWithRootControl(IControl<?, ?> rootControl) {
        return this.pushLayer((ILayer<?>)new Layer().setRootControl((IControl)rootControl));
    }

    @Override
    public void removeLayer(ILayer<?> layer) {
        this.layers.removeStrictlyFirstOccurrenceOf(layer);
        this.runProbableRemoveLayerAction();
    }

    @Override
    public ILayerStack setRemoveLayerAction(Runnable removeLayerAction) {
        Validator.assertThat(removeLayerAction).thatIsNamed("remove layer action").isNotNull();
        this.removeLayerAction = removeLayerAction;
        return this;
    }

    private void runProbableRemoveLayerAction() {
        if (this.hasRemoveLayerAction()) {
            this.removeLayerAction.run();
        }
    }
}

