/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.independent.math.NumberComparator;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.core.web.cssmodel.CssRule;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.systemapi.gui.box.ContentAlignment;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.IWebGui;

public final class LayerCssBuilder {
    private LayerCssBuilder() {
    }

    public static CssRule getCssRuleForLayer(ILayer<?> layer) {
        return CssRule.withSelectorAndProperties(LayerCssBuilder.getCssSelectorForLayer(layer), LayerCssBuilder.getCssPropertiesForLayer(layer));
    }

    private static String getCssSelectorForLayer(ILayer<?> layer) {
        return "#" + layer.getInternalId();
    }

    private static IContainer<ICssProperty> getCssPropertiesForLayer(ILayer<?> layer) {
        LinkedList<ICssProperty> cssProperties = LinkedList.createEmpty();
        if (((IWebGui)layer.getStoredParentGui()).getStoredTopLayer() == layer) {
            cssProperties.addAtEnd(CssProperty.withNameAndValue("position", "absolute"));
        } else {
            cssProperties.addAtEnd(CssProperty.withNameAndValue("position", "fixed"));
        }
        if (!NumberComparator.isOne(layer.getOpacity())) {
            cssProperties.addAtEnd(CssProperty.withNameAndValue("opacity", layer.getOpacity()));
        }
        cssProperties.addAtEnd(LayerCssBuilder.getZIndexCssPropertyForLayer(layer), CssProperty.withNameAndValue("min-width", "100vw"), CssProperty.withNameAndValue("min-height", "100vh"), CssProperty.withNameAndValue("display", "flex"), LayerCssBuilder.getJustifyContentCssPropertyForLayer(layer), LayerCssBuilder.getAlignItemsCssPropertyForLayer(layer));
        if (layer.hasBackground()) {
            cssProperties.addAtEnd(layer.getBackground().toCssProperties());
        }
        return cssProperties;
    }

    private static CssProperty getZIndexCssPropertyForLayer(ILayer<?> layer) {
        return CssProperty.withNameAndValue("z-index", LayerCssBuilder.getCssZIndexForLayer(layer));
    }

    private static int getCssZIndexForLayer(ILayer<?> layer) {
        if (!layer.belongsToGui()) {
            return 0;
        }
        return ((IWebGui)layer.getStoredParentGui()).getStoredLayers().getOneBasedIndexOfFirstOccurrenceOf(layer);
    }

    private static CssProperty getJustifyContentCssPropertyForLayer(ILayer<?> layer) {
        return LayerCssBuilder.getJustifyContentCssPropertyForContentAlignment(layer.getContentAlignment());
    }

    private static CssProperty getJustifyContentCssPropertyForContentAlignment(ContentAlignment contentAlignment) {
        return switch (contentAlignment) {
            case ContentAlignment.TOP_LEFT, ContentAlignment.LEFT, ContentAlignment.BOTTOM_LEFT -> CssProperty.withNameAndValue("justify-content", "left");
            case ContentAlignment.TOP, ContentAlignment.CENTER, ContentAlignment.BOTTOM -> CssProperty.withNameAndValue("justify-content", "center");
            case ContentAlignment.TOP_RIGHT, ContentAlignment.RIGHT, ContentAlignment.BOTTOM_RIGHT -> CssProperty.withNameAndValue("justify-content", "right");
            default -> throw InvalidArgumentException.forArgument((Object)contentAlignment);
        };
    }

    private static CssProperty getAlignItemsCssPropertyForLayer(ILayer<?> layer) {
        return LayerCssBuilder.getAlignItemsCssPropertyForContentAlignment(layer.getContentAlignment());
    }

    private static CssProperty getAlignItemsCssPropertyForContentAlignment(ContentAlignment contentAlignment) {
        return switch (contentAlignment) {
            case ContentAlignment.BOTTOM_LEFT, ContentAlignment.BOTTOM, ContentAlignment.BOTTOM_RIGHT -> CssProperty.withNameAndValue("align-items", "end");
            case ContentAlignment.LEFT, ContentAlignment.CENTER, ContentAlignment.RIGHT -> CssProperty.withNameAndValue("align-items", "center");
            case ContentAlignment.TOP_LEFT, ContentAlignment.TOP, ContentAlignment.TOP_RIGHT -> CssProperty.withNameAndValue("align-items", "start");
            default -> throw InvalidArgumentException.forArgument((Object)contentAlignment);
        };
    }
}

