/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.controltool;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.core.web.cssmodel.CssRule;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.coreapi.web.cssmodel.ICssRule;
import ch.nolix.system.gui.cssmapper.CssPropertyMapper;
import ch.nolix.system.webgui.controltool.CssValueMapper;
import ch.nolix.systemapi.gui.box.ICornerShadow;
import ch.nolix.systemapi.gui.cssmapper.ICssPropertyMapper;
import ch.nolix.systemapi.gui.presence.Presence;
import ch.nolix.systemapi.webgui.controlstyle.IControlStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import java.util.Locale;
import java.util.Optional;

public abstract class AbstractControlCssBuilder<C extends IControl<C, S>, S extends IControlStyle<S>>
implements IControlCssBuilder<C, S> {
    private static final ICssPropertyMapper CSS_PROPERTY_MAPPER = new CssPropertyMapper();

    @Override
    public final IContainer<ICssRule> createCssRulesForControl(C control) {
        LinkedList<ICssRule> cssRules = LinkedList.createEmpty();
        this.fillUpAllStateCssRulesIntoList(cssRules, control);
        this.fillUpBaseCssRulesIntoList(cssRules, control);
        this.fillUpHoverCssRulesIntoList(cssRules, control);
        this.fillUpFocusCssRulesIntoList(cssRules, control);
        return cssRules;
    }

    protected abstract void fillUpAdditionalCssRulesForControlAndAllStatesIntoList(C var1, ILinkedList<? super ICssRule> var2);

    protected abstract void fillUpAdditionalCssRulesForControlAndStateIntoList(C var1, ControlState var2, ILinkedList<? super ICssRule> var3);

    protected abstract void fillUpCssPropertiesForControlAndAllStatesIntoList(C var1, ILinkedList<ICssProperty> var2);

    protected abstract void fillUpCssPropertiesForControlAndStateIntoList(C var1, ControlState var2, ILinkedList<ICssProperty> var3);

    private void fillUpAllStateCssRulesIntoList(ILinkedList<ICssRule> list, C control) {
        String allStateSelectorPrefix = this.getCssSelectorForControlAndAllStates(control);
        LinkedList<ICssRule> allStateCssRules = LinkedList.createEmpty();
        this.fillUpCssRulesForControlAndAllStatesIntoList(control, allStateCssRules);
        for (ICssRule r : allStateCssRules) {
            list.addAtEnd(r.withPrefixedSelector(allStateSelectorPrefix + " "));
        }
    }

    private void fillUpBaseCssRulesIntoList(ILinkedList<ICssRule> list, C control) {
        String baseSelectorPrefix = this.getCssSelectorForControlAndState(control, ControlState.BASE);
        LinkedList<ICssRule> baseCssRules = LinkedList.createEmpty();
        this.fillUpCssRulesForControlAndStateIntoList(control, ControlState.BASE, baseCssRules);
        for (ICssRule r : baseCssRules) {
            list.addAtEnd(r.withPrefixedSelector(baseSelectorPrefix + " "));
        }
    }

    private String getCssSelectorForControlAndAllStates(C control) {
        return "#" + control.getInternalId();
    }

    private String getCssSelectorForControlAndState(C control, ControlState state) {
        return switch (state) {
            case ControlState.BASE -> "#" + control.getInternalId();
            case ControlState.FOCUS -> "#" + control.getInternalId() + ":focus";
            case ControlState.HOVER -> "#" + control.getInternalId() + ":hover";
            default -> throw InvalidArgumentException.forArgument((Object)state);
        };
    }

    private void fillUpCssRulesForControlAndAllStatesIntoList(C control, ILinkedList<ICssRule> list) {
        list.addAtEnd(this.getCssRuleForControlAndAllStates(control));
        this.fillUpAdditionalCssRulesForControlAndAllStatesIntoList(control, list);
    }

    private void fillUpCssRulesForControlAndStateIntoList(C control, ControlState state, ILinkedList<ICssRule> list) {
        list.addAtEnd(this.getCssRuleForControlAndState(control, state));
        this.fillUpAdditionalCssRulesForControlAndStateIntoList(control, state, list);
    }

    private void fillUpFocusCssRulesIntoList(ILinkedList<ICssRule> list, C control) {
        String focusSelectorPrefix = this.getCssSelectorForControlAndState(control, ControlState.FOCUS);
        LinkedList<ICssRule> focusCssRules = LinkedList.createEmpty();
        this.fillUpCssRulesForControlAndStateIntoList(control, ControlState.FOCUS, focusCssRules);
        for (ICssRule r : focusCssRules) {
            list.addAtEnd(r.withPrefixedSelector(focusSelectorPrefix + " "));
        }
    }

    private void fillUpHoverCssRulesIntoList(ILinkedList<ICssRule> list, C control) {
        String hoverSelectorPrefix = this.getCssSelectorForControlAndState(control, ControlState.HOVER);
        LinkedList<ICssRule> hoverCssRules = LinkedList.createEmpty();
        this.fillUpCssRulesForControlAndStateIntoList(control, ControlState.HOVER, hoverCssRules);
        for (ICssRule r : hoverCssRules) {
            list.addAtEnd(r.withPrefixedSelector(hoverSelectorPrefix + " "));
        }
    }

    private void fillUpMandatoryCssPropertiesForControlAndStateIntoList(C control, ControlState state, ILinkedList<ICssProperty> list) {
        Object style = control.getStoredStyle();
        list.addAtEnd(CssProperty.withNameAndValue("border-radius", style.getCornerRadiusWhenHasState(state) + "px"), (ICssProperty[])new ICssProperty[]{CssProperty.withNameAndValue("border-style", "solid"), CssProperty.withNameAndValue("border-left-width", String.valueOf(style.getLeftBorderThicknessWhenHasState(state)) + "px"), CssProperty.withNameAndValue("border-left-color", CssValueMapper.mapColorToCssValue(style.getLeftBorderColorWhenHasState(state))), CssProperty.withNameAndValue("padding-left", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(style.getLeftPaddingWhenHasState(state), "vw")), CssProperty.withNameAndValue("border-right-width", String.valueOf(style.getRightBorderThicknessWhenHasState(state)) + "px"), CssProperty.withNameAndValue("border-right-color", CssValueMapper.mapColorToCssValue(style.getRightBorderColorWhenHasState(state))), CssProperty.withNameAndValue("padding-right", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(style.getRightPaddingWhenHasState(state), "vw")), CssProperty.withNameAndValue("border-top-width", String.valueOf(style.getTopBorderThicknessWhenHasState(state)) + "px"), CssProperty.withNameAndValue("border-top-color", CssValueMapper.mapColorToCssValue(style.getTopBorderColorWhenHasState(state))), CssProperty.withNameAndValue("padding-top", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(style.getTopPaddingWhenHasState(state), "vw")), CssProperty.withNameAndValue("border-bottom-width", String.valueOf(style.getBottomBorderThicknessWhenHasState(state)) + "px"), CssProperty.withNameAndValue("border-bottom-color", CssValueMapper.mapColorToCssValue(style.getBottomBorderColorWhenHasState(state))), CssProperty.withNameAndValue("padding-bottom", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(style.getBottomPaddingWhenHasState(state), "vw"))});
        list.addAtEnd(style.getBackgroundWhenHasState(state).toCssProperties());
    }

    private void fillUpOptionalCssPropertiesForControlAndStateIntoList(C control, ControlState state, ILinkedList<ICssProperty> list) {
        Object style = control.getStoredStyle();
        if (style.definesWidthForState(state)) {
            list.addAtEnd(CssProperty.withNameAndValue("width", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(style.getWidthForState(state), "vw")));
        }
        if (style.definesHeightForState(state)) {
            list.addAtEnd(CssProperty.withNameAndValue("height", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(style.getHeightForState(state), "vh")));
        }
    }

    private IContainer<ICssProperty> getCssPropertiesForControlAndAllStates(C control) {
        LinkedList<ICssProperty> cssPropertiesForBaseState = LinkedList.createEmpty();
        this.onOwnFillUpCssPropertiesForControlAndAllStatesIntoList(control, cssPropertiesForBaseState);
        return cssPropertiesForBaseState;
    }

    private IContainer<ICssProperty> getCssPropertiesForControlAndState(C control, ControlState state) {
        LinkedList<ICssProperty> cssProperties = LinkedList.createEmpty();
        this.onOwnFillUpCssPropertiesForControlAndStateIntoList(control, state, cssProperties);
        return cssProperties;
    }

    private final ICssRule getCssRuleForControlAndAllStates(C control) {
        return CssRule.withSelectorAndProperties("", this.getCssPropertiesForControlAndAllStates(control));
    }

    private final ICssRule getCssRuleForControlAndState(C control, ControlState state) {
        return CssRule.withSelectorAndProperties("", this.getCssPropertiesForControlAndState(control, state));
    }

    private ICssProperty getFontWeightCssPropertyForControlAndState(C control, ControlState state) {
        Object style = control.getStoredStyle();
        boolean boldTextFlag = style.getBoldTextFlagWhenHasState(state);
        if (!boldTextFlag) {
            return CssProperty.withNameAndValue("font-weight", "normal");
        }
        return CssProperty.withNameAndValue("font-weight", "bold");
    }

    private void onOwnFillUpCssPropertiesForControlAndAllStatesIntoList(C control, ILinkedList<ICssProperty> list) {
        Presence presence = control.getPresence();
        switch (presence) {
            case VISIBLE: {
                break;
            }
            case INVISIBLE: {
                list.addAtEnd(CssProperty.withNameAndValue("visibility", "hidden"));
                break;
            }
            case COLLAPSED: {
                list.addAtEnd(CssProperty.withNameAndValue("display", "none"));
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)presence);
            }
        }
        if (control.hasMinWidth()) {
            list.addAtEnd(CssProperty.withNameAndValue("min-width", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(control.getMinWidth(), "vw")));
        }
        if (control.hasMinHeight()) {
            list.addAtEnd(CssProperty.withNameAndValue("min-height", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(control.getMinHeight(), "vh")));
        }
        if (control.hasMaxWidth()) {
            list.addAtEnd(CssProperty.withNameAndValue("max-width", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(control.getMaxWidth(), "vw")));
        }
        if (control.hasMaxHeight()) {
            list.addAtEnd(CssProperty.withNameAndValue("max-height", CssValueMapper.mapRelativeOrAbsoluteIntToCssValue(control.getMaxHeight(), "vh")));
        }
        list.addAtEnd(CssProperty.withNameAndValue("cursor", control.getCursorIcon().toCssValue()));
        this.fillUpCssPropertiesForControlAndAllStatesIntoList(control, list);
    }

    private void onOwnFillUpCssPropertiesForControlAndStateIntoList(C control, ControlState state, ILinkedList<ICssProperty> list) {
        IContainer<ICornerShadow> cornerShadows;
        Optional<ICssProperty> cornerShadowCssProperty;
        Object style = control.getStoredStyle();
        double opacity = style.getOpacityWhenHasState(state);
        if (opacity < 1.0) {
            list.addAtEnd(CssProperty.withNameAndValue("opacity", opacity));
        }
        if ((cornerShadowCssProperty = CSS_PROPERTY_MAPPER.mapCornerShadowsToOptionalCssProperty(cornerShadows = style.getCornerShadowsWhenHasState(state))).isPresent()) {
            list.addAtEnd(cornerShadowCssProperty.get());
        }
        list.addAtEnd(CssProperty.withNameAndValue("color", CssValueMapper.mapColorToCssValue(style.getTextColorWhenHasState(state))), (ICssProperty[])new ICssProperty[]{CssProperty.withNameAndValue("font-family", style.getFontWhenHasState(state).getCode().toLowerCase(Locale.ENGLISH)), CssProperty.withNameAndValue("font-size", String.valueOf(style.getTextSizeWhenHasState(state)) + "px"), this.getFontWeightCssPropertyForControlAndState(control, state)});
        if (style.definesTextLineDecorationForState(state)) {
            list.addAtEnd(CSS_PROPERTY_MAPPER.mapLineDecorationToCssProperty(style.getTextLineDecorationWhenHasState(state)));
        }
        this.fillUpOptionalCssPropertiesForControlAndStateIntoList(control, state, list);
        this.fillUpMandatoryCssPropertiesForControlAndStateIntoList(control, state, list);
        this.fillUpCssPropertiesForControlAndStateIntoList(control, state, list);
    }
}

