/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.controlstyle;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.element.multistateconfiguration.AbstractMultiStateConfiguration;
import ch.nolix.system.element.multistateconfiguration.CascadingProperty;
import ch.nolix.system.element.multistateconfiguration.NonCascadingProperty;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.gui.font.Font;
import ch.nolix.systemapi.gui.font.LineDecoration;
import ch.nolix.systemapi.webgui.controlstyle.IControlBaseStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

abstract class AbstractControlBaseStyle<C extends IControlBaseStyle<C>>
extends AbstractMultiStateConfiguration<C, ControlState>
implements IControlBaseStyle<C> {
    public static final double DEFAULT_OPACITY = 1.0;
    public static final Font DEFAULT_FONT = Font.ARIAL;
    public static final boolean DEFAULT_BOLD_TEXT_FLAG = false;
    public static final int DEAULT_TEXT_SIZE = 20;
    public static final LineDecoration DEFAULT_TEXT_LINE_DECORATION = LineDecoration.UNDERLINE;
    public static final Color DEFAULT_TEXT_COLOR = X11ColorCatalog.BLACK;
    private final NonCascadingProperty<ControlState, Double> memberOpacity = new NonCascadingProperty<ControlState, Double>("Opacity", ControlState.class, s -> this.getOpacityFromString(s.getSingleChildNodeHeader()), Node::withChildNode, this::forStateSetOpacity, 1.0);
    private final CascadingProperty<ControlState, Font> memberFont = new CascadingProperty<ControlState, Font>("Font", ControlState.class, Font::fromSpecification, Node::fromEnum, DEFAULT_FONT);
    private final CascadingProperty<ControlState, Boolean> memberBoldTextFlag = CascadingProperty.forBooleanWithNameAndStateClassAndDefaultValue("BoldText", ControlState.class, false);
    private final CascadingProperty<ControlState, Integer> memberTextSize = CascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("TextSize", ControlState.class, this::forStateSetTextSize, 20);
    private final CascadingProperty<ControlState, LineDecoration> memberTextLineDecoration = new CascadingProperty<ControlState, LineDecoration>("TextLineDecoration", ControlState.class, LineDecoration::fromSpecification, Node::fromEnum, DEFAULT_TEXT_LINE_DECORATION);
    private final CascadingProperty<ControlState, IColor> memberTextColor = new CascadingProperty<ControlState, Color>("TextColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_TEXT_COLOR);

    protected AbstractControlBaseStyle() {
        super(ControlState.BASE);
        this.memberTextLineDecoration.setUndefined();
    }

    @Override
    public final <C2 extends IControlBaseStyle<C2>> void addChild(C2 controlStyle) {
        this.internalAddChild(controlStyle);
    }

    @Override
    public boolean definesTextLineDecorationForState(ControlState state) {
        return this.memberTextLineDecoration.hasValueForState(state);
    }

    @Override
    public final boolean getBoldTextFlagWhenHasState(ControlState state) {
        return (Boolean)this.memberBoldTextFlag.getValueWhenHasState(state);
    }

    @Override
    public final Font getFontWhenHasState(ControlState state) {
        return (Font)((Object)this.memberFont.getValueWhenHasState(state));
    }

    @Override
    public final double getOpacityWhenHasState(ControlState state) {
        return (Double)this.memberOpacity.getValueWhenHasState(state);
    }

    @Override
    public final IColor getTextColorWhenHasState(ControlState state) {
        return (IColor)this.memberTextColor.getValueWhenHasState(state);
    }

    @Override
    public LineDecoration getTextLineDecorationWhenHasState(ControlState state) {
        return (LineDecoration)((Object)this.memberTextLineDecoration.getValueWhenHasState(state));
    }

    @Override
    public final int getTextSizeWhenHasState(ControlState state) {
        return (Integer)this.memberTextSize.getValueWhenHasState(state);
    }

    @Override
    public final void removeCustomBoldTextFlags() {
        this.memberBoldTextFlag.setUndefined();
    }

    @Override
    public final void removeCustomFonts() {
        this.memberFont.setUndefined();
    }

    @Override
    public final void removeCustomOpacities() {
        this.memberOpacity.setUndefined();
    }

    @Override
    public final void removeCustomTextColors() {
        this.memberTextColor.setUndefined();
    }

    @Override
    public void removeCustomTextLineDecorations() {
        this.memberTextLineDecoration.setUndefined();
    }

    @Override
    public final void removeCustomTextSizes() {
        this.memberTextSize.setUndefined();
    }

    @Override
    public final C forStateSetBoldTextFlag(ControlState state, boolean boldTextFlag) {
        this.memberBoldTextFlag.setValueForState(state, boldTextFlag);
        return (C)((IControlBaseStyle)this.asConcrete());
    }

    @Override
    public final C forStateSetFont(ControlState state, Font font) {
        this.memberFont.setValueForState(state, font);
        return (C)((IControlBaseStyle)this.asConcrete());
    }

    @Override
    public final C forStateSetOpacity(ControlState state, double opacity) {
        Validator.assertThat(opacity).thatIsNamed("opacity").isBetween(0.0, 1.0);
        this.memberOpacity.setValueForState(state, opacity);
        return (C)((IControlBaseStyle)this.asConcrete());
    }

    @Override
    public final C forStateSetTextColor(ControlState state, IColor textColor) {
        this.memberTextColor.setValueForState(state, textColor);
        return (C)((IControlBaseStyle)this.asConcrete());
    }

    @Override
    public C forStateSetTextLineDecoration(ControlState state, LineDecoration textLineDecoration) {
        this.memberTextLineDecoration.setValueForState(state, textLineDecoration);
        return (C)((IControlBaseStyle)this.asConcrete());
    }

    @Override
    public final C forStateSetTextSize(ControlState state, int textSize) {
        Validator.assertThat(textSize).thatIsNamed("text size").isPositive();
        this.memberTextSize.setValueForState(state, textSize);
        return (C)((IControlBaseStyle)this.asConcrete());
    }

    private double getOpacityFromString(String string) {
        Validator.assertThat(string).thatIsNamed(String.class).isNotNull();
        if (!string.endsWith("%")) {
            return Double.valueOf(string);
        }
        return Double.valueOf(string.substring(0, string.length() - 1)) / 100.0;
    }
}

