/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.textbox;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.webatomiccontrol.textbox.TextboxCssBuilder;
import ch.nolix.system.webatomiccontrol.textbox.TextboxHtmlBuilder;
import ch.nolix.system.webatomiccontrol.textbox.TextboxStyle;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.gui.model.CursorIcon;
import ch.nolix.systemapi.webatomiccontrol.textbox.ITextbox;
import ch.nolix.systemapi.webatomiccontrol.textbox.ITextboxStyle;
import ch.nolix.systemapi.webatomiccontrol.textbox.TextMode;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;
import java.util.function.Consumer;

public final class Textbox
extends Control<ITextbox, ITextboxStyle>
implements ITextbox {
    public static final String DEFAULT_TEXT = "";
    public static final TextMode DEFAULT_TEXT_MODE = TextMode.NORMAL;
    private static final String TEXT_HEADER = "Text";
    private static final String TEXT_MODE_HEADER = "TextMode";
    private static final TextboxHtmlBuilder HTML_BUILDER = new TextboxHtmlBuilder();
    private static final TextboxCssBuilder CSS_BUILDER = new TextboxCssBuilder();
    private final MutableValue<String> memberText = MutableValue.forString("Text", "", this::setText);
    private MutableValue<TextMode> textMode = new MutableValue<TextMode>("TextMode", DEFAULT_TEXT_MODE, this::setTextMode, TextMode::fromSpecification, Node::fromEnum);
    private Consumer<String> updateTextAction;

    public Textbox() {
        this.reset();
        ((ITextboxStyle)this.getStoredStyle()).forStateSetBorderThickness(ControlState.BASE, 1);
    }

    @Override
    public void emptyText() {
        this.setText(DEFAULT_TEXT);
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.of("return x.value;");
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public String getText() {
        return (String)this.memberText.getValue();
    }

    @Override
    public TextMode getTextMode() {
        return (TextMode)((Object)this.textMode.getValue());
    }

    @Override
    public String getUserInput() {
        return this.getText();
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public void removeUpdateTextAction() {
        this.updateTextAction = null;
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "runHtmlEvent");
    }

    @Override
    public Textbox setText(String text) {
        this.memberText.setValue(text);
        this.runOptionalUpdateTextActionForText(text);
        return this;
    }

    @Override
    public Textbox setTextMode(TextMode textMode) {
        this.textMode.setValue(textMode);
        return this;
    }

    @Override
    public Textbox setUpdateTextAction(Runnable updateTextAction) {
        Validator.assertThat(updateTextAction).thatIsNamed("update text action").isNotNull();
        return this.setUpdateTextAction(t -> updateTextAction.run());
    }

    @Override
    public Textbox setUpdateTextAction(Consumer<String> updateTextAction) {
        Validator.assertThat(updateTextAction).thatIsNamed("update text action").isNotNull();
        this.updateTextAction = updateTextAction;
        return this;
    }

    @Override
    public Textbox setUserInput(String userInput) {
        return this.setText(userInput);
    }

    @Override
    protected TextboxStyle createStyle() {
        return new TextboxStyle();
    }

    @Override
    protected IControlCssBuilder<ITextbox, ITextboxStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<ITextbox> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    @Override
    protected void resetControl() {
        this.emptyText();
        this.setTextMode(DEFAULT_TEXT_MODE);
        this.removeUpdateTextAction();
        this.setCursorIcon(CursorIcon.EDIT);
    }

    private boolean hasUpdateTextAction() {
        return this.updateTextAction != null;
    }

    private void runOptionalUpdateTextActionForText(String text) {
        if (this.hasUpdateTextAction()) {
            this.updateTextAction.accept(text);
        }
    }
}

