/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlschema.statementcreator;

import ch.nolix.systemapi.sqlschema.model.ColumnConstraintDto;
import ch.nolix.systemapi.sqlschema.model.ColumnDto;
import ch.nolix.systemapi.sqlschema.model.DataTypeDto;
import ch.nolix.systemapi.sqlschema.model.TableDto;
import ch.nolix.systemapi.sqlschema.statementcreator.IStatementCreator;

public final class StatementCreator
implements IStatementCreator {
    @Override
    public String createStatementToAddColumn(String tableName, ColumnDto column) {
        return "ALTER TABLE " + tableName + " ADD " + this.getColumnAsSql(column) + ";";
    }

    @Override
    public String createStatementToAddTable(TableDto table) {
        return "CREATE TABLE " + table.name() + " (" + table.columns().getViewOf(this::getColumnAsSql).toStringWithSeparator(", ") + ");";
    }

    @Override
    public String createStatementToDeleteColumn(String tableName, String columnName) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + columnName + ";";
    }

    @Override
    public String createStatementToDeleteColumnIfExists(String tableName, String columnName) {
        return "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME ='" + tableName + "' AND COLUMN_NAME = '" + columnName + "')BEGIN ALTER TABLE " + tableName + " DROP COLUMN " + columnName + " END;";
    }

    @Override
    public String createStatementToDeleteTable(String tableName) {
        return "DROP TABLE " + tableName + ";";
    }

    @Override
    public String createStatementToRenameColumn(String tableName, String columnName, String newColumnName) {
        return "ALTER TABLE " + tableName + " RENAME COLUMN " + columnName + " TO " + newColumnName + ";";
    }

    @Override
    public String createStatementToRenameColumnIfExists(String tableName, String columnName, String newColumnName) {
        return "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME ='" + tableName + "' AND COLUMN_NAME = '" + columnName + "')BEGIN ALTER TABLE " + tableName + " RENAME COLUMN " + columnName + " TO " + newColumnName + " END;";
    }

    @Override
    public String createStatementToRenameTable(String tableName, String newTableName) {
        return "ALTER TABLE " + tableName + " RENAME TO " + newTableName + ";";
    }

    private String getColumnAsSql(ColumnDto column) {
        String sql = column.name() + " " + this.getDataTypeAsSql(column.dataType());
        if (column.constraints().containsAny()) {
            sql = sql + this.getConstraintsAsSql(column);
        }
        return sql;
    }

    private String getConstraintAsSql(ColumnConstraintDto constraint) {
        String sql = constraint.constraint().toString().replace("_", " ");
        if (constraint.parameters().containsAny()) {
            this.getConstraintParametersAsSql(constraint);
        }
        return sql;
    }

    private String getConstraintsAsSql(ColumnDto column) {
        return column.constraints().getViewOf(this::getConstraintAsSql).toStringWithSeparator(",");
    }

    private String getConstraintParametersAsSql(ColumnConstraintDto constraint) {
        return "(" + constraint.parameters().toStringWithSeparator(",") + ")";
    }

    private String getDataTypeAsSql(DataTypeDto dataType) {
        String parameter = dataType.nullableParameter();
        if (parameter != null) {
            return dataType.name() + "(" + parameter + ")";
        }
        return dataType.name();
    }
}

