/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlschema.adapter;

import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.resourcecontrol.resourcepool.IResourcePool;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.sqlschema.adapter.SchemaReader;
import ch.nolix.system.sqlschema.adapter.SchemaWriter;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaReader;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.sqlschema.model.ColumnDto;
import ch.nolix.systemapi.sqlschema.model.TableDto;

public final class SqlSchemaAdapter
implements ISchemaAdapter {
    private final ICloseController closeController = CloseController.forElement(this);
    private final ISqlConnection sqlConnection;
    private final ISchemaReader schemaReader;
    private final ISchemaWriter schemaWriter;

    private SqlSchemaAdapter(String databaseName, IResourcePool<ISqlConnection> sqlConnectionPool) {
        this.sqlConnection = sqlConnectionPool.borrowResource();
        this.schemaReader = SchemaReader.forDatabaseNameAndSqlConnection(databaseName, this.sqlConnection);
        this.schemaWriter = SchemaWriter.forDatabasNameAndSqlConnection(databaseName, this.sqlConnection);
        this.getStoredCloseController().createCloseDependencyTo(this.schemaReader);
        this.getStoredCloseController().createCloseDependencyTo(this.schemaWriter);
    }

    public static SqlSchemaAdapter forDatabaseNameAndWithSqlConnectionPool(String databaseName, IResourcePool<ISqlConnection> sqlConnectionPool) {
        return new SqlSchemaAdapter(databaseName, sqlConnectionPool);
    }

    @Override
    public void addAdditionalSqlStatements(IContainer<String> additionalSqlStatements) {
        this.schemaWriter.addAdditionalSqlStatements(additionalSqlStatements);
    }

    @Override
    public void addColumn(TableIdentification table, ColumnDto column) {
        this.schemaWriter.addColumn(table, column);
    }

    @Override
    public void addColumns(TableIdentification table, IContainer<ColumnDto> columns) {
        for (ColumnDto c : columns) {
            this.addColumn(table, c);
        }
    }

    @Override
    public void addTable(TableDto table) {
        this.schemaWriter.addTable(table);
    }

    @Override
    public void addTables(IContainer<TableDto> tables) {
        for (TableDto t : tables) {
            this.addTable(t);
        }
    }

    @Override
    public void addTables(TableDto table, TableDto ... tables) {
        this.addTable(table);
        TableDto[] tableDtoArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            TableDto t = tableDtoArray[n2];
            this.addTable(t);
            ++n2;
        }
    }

    @Override
    public boolean columnIsEmpty(String tableName, String columnName) {
        return this.schemaReader.columnIsEmpty(tableName, columnName);
    }

    @Override
    public void deleteColumn(String tableName, String columnName) {
        this.schemaWriter.deleteColumn(tableName, columnName);
    }

    @Override
    public void deleteColumnIfExists(String tableName, String columnName) {
        this.schemaWriter.deleteColumnIfExists(tableName, columnName);
    }

    @Override
    public void deleteTable(String tableName) {
        this.schemaWriter.deleteTable(tableName);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getSaveCount() {
        return this.schemaWriter.getSaveCount();
    }

    @Override
    public boolean hasChanges() {
        return this.schemaWriter.hasChanges();
    }

    @Override
    public TableDto loadTable(String tableName) {
        return this.schemaReader.loadTable(tableName);
    }

    @Override
    public int getTableCount() {
        return this.schemaReader.getTableCount();
    }

    @Override
    public IContainer<TableDto> loadTables() {
        return this.schemaReader.loadTables();
    }

    @Override
    public void noteClose() {
        this.sqlConnection.close();
    }

    @Override
    public void renameColumn(String tableName, String columnName, String newColumnName) {
        this.schemaWriter.renameColumn(tableName, columnName, newColumnName);
    }

    @Override
    public void renameColumnIfExists(String tableName, String columnName, String newColumnName) {
        this.schemaWriter.renameColumnIfExists(tableName, columnName, newColumnName);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        this.schemaWriter.renameTable(tableName, newTableName);
    }

    @Override
    public void reset() {
        this.schemaWriter.reset();
    }

    @Override
    public void saveChanges() {
        this.schemaWriter.saveChanges();
    }

    @Override
    public boolean tableExist() {
        return this.schemaReader.tableExist();
    }

    @Override
    public boolean tableExists(String tableName) {
        return this.schemaReader.tableExists(tableName);
    }
}

