/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmiddata.modelmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.middata.valuemapper.ValueMapper;
import ch.nolix.systemapi.middata.model.FieldDto;
import ch.nolix.systemapi.middata.valuemapper.IValueMapper;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.sqlmiddata.modelmapper.IContentFieldDtoMapper;

public final class ContentFieldDtoMapper
implements IContentFieldDtoMapper {
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();

    @Override
    public FieldDto mapNullableStringRepresentedValueToContentFieldDto(String nullableStringRepresentedValue, String nullableAdditionalValue, ColumnViewDto columnView) {
        String columnName = columnView.name();
        FieldType fieldType = columnView.fieldType();
        switch (fieldType) {
            case VALUE_FIELD: {
                DataType dataType = columnView.dataType();
                Object value = VALUE_MAPPER.mapStringToValue(nullableStringRepresentedValue, dataType);
                return new FieldDto(columnName, value, null);
            }
            case REFERENCE: 
            case BACK_REFERENCE: {
                DataType dataType2 = columnView.dataType();
                Object value2 = VALUE_MAPPER.mapStringToValue(nullableStringRepresentedValue, dataType2);
                return new FieldDto(columnName, value2, nullableAdditionalValue);
            }
            case OPTIONAL_VALUE_FIELD: {
                if (nullableStringRepresentedValue != null) {
                    DataType dataType3 = columnView.dataType();
                    Object value3 = VALUE_MAPPER.mapStringToValue(nullableStringRepresentedValue, dataType3);
                    return new FieldDto(columnName, value3, null);
                }
                return new FieldDto(columnName, null, null);
            }
            case OPTIONAL_REFERENCE: 
            case OPTIONAL_BACK_REFERENCE: {
                if (nullableStringRepresentedValue != null) {
                    DataType dataType4 = columnView.dataType();
                    Object value4 = VALUE_MAPPER.mapStringToValue(nullableStringRepresentedValue, dataType4);
                    return new FieldDto(columnName, value4, nullableAdditionalValue);
                }
                return new FieldDto(columnName, null, null);
            }
            case MULTI_VALUE_FIELD: 
            case MULTI_REFERENCE: 
            case MULTI_BACK_REFERENCE: {
                return new FieldDto(columnName, null, null);
            }
        }
        throw InvalidArgumentException.forArgument((Object)fieldType);
    }
}

