/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modeltool;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectschema.modeltool.ColumnTool;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modeltool.IColumnTool;

public final class TableToolHelper {
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    private TableToolHelper() {
    }

    public static IContainer<? extends IColumn> getStoredBackReferencingColumnsWhenBelongsToDatabase(ITable table) {
        IContainer columns = ((IDatabase)table.getStoredParentDatabase()).getStoredTables().toMultiples(ITable::getStoredColumns);
        return table.getStoredColumns().getStoredSelected(c -> columns.containsAny(c2 -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, (IColumn)c2)));
    }

    public static IContainer<? extends IColumn> getStoredBackReferencingColumnsWhenDoesNotBelongToDatabase(ITable table) {
        IContainer<? extends IColumn> columns = table.getStoredColumns();
        return columns.getStoredSelected(c -> columns.containsAny(c2 -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, (IColumn)c2)));
    }

    public static IContainer<? extends IColumn> getStoredReferencingColumnsWhenBelongsToDatabase(ITable table) {
        return ((IDatabase)table.getStoredParentDatabase()).getStoredTables().toMultiples(ITable::getStoredColumns).getStoredSelected(c -> COLUMN_TOOL.referencesGivenTable((IColumn)c, table));
    }

    public static IContainer<? extends IColumn> getStoredReferencingColumnsWhenDoesNotBelongToDatabase(ITable table) {
        return table.getStoredColumns().getStoredSelected(c -> COLUMN_TOOL.referencesGivenTable((IColumn)c, table));
    }
}

