/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modeltool;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectschema.modeltool.ColumnTool;
import ch.nolix.system.objectschema.modeltool.TableToolHelper;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modeltool.IColumnTool;
import ch.nolix.systemapi.objectschema.modeltool.ITableTool;

public final class TableTool
extends DatabaseObjectExaminer
implements ITableTool {
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    @Override
    public int getColumnCount(ITable table) {
        return table.getStoredColumns().getCount();
    }

    @Override
    public IContainer<? extends IColumn> getStoredBaseBackReferenceColumns(ITable table) {
        return table.getStoredColumns().getStoredSelected(COLUMN_TOOL::isABackReferenceColumn);
    }

    @Override
    public IContainer<? extends IColumn> getStoredBackReferencingColumns(ITable table) {
        if (!table.belongsToDatabase()) {
            return TableToolHelper.getStoredBackReferencingColumnsWhenDoesNotBelongToDatabase(table);
        }
        return TableToolHelper.getStoredBackReferencingColumnsWhenBelongsToDatabase(table);
    }

    @Override
    public IContainer<? extends IColumn> getStoredReferencingColumns(ITable table) {
        if (!table.belongsToDatabase()) {
            return TableToolHelper.getStoredReferencingColumnsWhenDoesNotBelongToDatabase(table);
        }
        return TableToolHelper.getStoredReferencingColumnsWhenBelongsToDatabase(table);
    }
}

