/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modelexaminer;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectschema.modelexaminer.TableExaminer;
import ch.nolix.system.objectschema.modelmutationexaminer.TableMutationExaminer;
import ch.nolix.system.objectschema.modelsearcher.DatabaseSearcher;
import ch.nolix.system.objectschema.modeltool.ColumnTool;
import ch.nolix.systemapi.midschema.fieldproperty.BaseFieldType;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelexaminer.IDatabaseExaminer;
import ch.nolix.systemapi.objectschema.modelexaminer.ITableExaminer;
import ch.nolix.systemapi.objectschema.modelmutationexaminer.ITableMutationExaminer;
import ch.nolix.systemapi.objectschema.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectschema.modeltool.IColumnTool;

public final class DatabaseExaminer
implements IDatabaseExaminer {
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final ITableExaminer TABLE_EXAMINER = new TableExaminer();
    private static final ITableMutationExaminer TABLE_MUTATION_EXAMINER = new TableMutationExaminer();
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    @Override
    public boolean allBackReferencesAreValid(IDatabase database) {
        IContainer<? extends IColumn> baseBackReferenceColumns = DATABASE_SEARCHER.getStoredBaseBackReferenceColumns(database);
        return baseBackReferenceColumns.containsOnly(COLUMN_TOOL::isAValidBackReferenceColumn);
    }

    @Override
    public boolean canAddTable(IDatabase database) {
        return database != null && database.isOpen();
    }

    @Override
    public boolean canAddTable(IDatabase database, ITable table) {
        return this.canAddTable(database) && TABLE_MUTATION_EXAMINER.canBeAddedToDatabase(table) && !this.containsTableWithName(database, table.getName()) && this.canAddGivenTableBecauseOfColumns(database, table);
    }

    @Override
    public boolean canSetName(String name) {
        return name != null && !name.isBlank();
    }

    @Override
    public boolean containsBackReferencededColumnByColumn(IDatabase database, IColumn column) {
        if (!COLUMN_TOOL.isABackReferenceColumn(column)) {
            return false;
        }
        return database != null && database.getStoredTables().containsAny(t -> TABLE_EXAMINER.containsColumnThatIsBackReferencedByColumn((ITable)t, column));
    }

    @Override
    public boolean containsTable(IDatabase database, ITable table) {
        return database != null && database.getStoredTables().contains(table);
    }

    @Override
    public boolean containsTableReferencedByColumn(IDatabase database, IColumn column) {
        if (!COLUMN_TOOL.isAReferenceColumn(column)) {
            return false;
        }
        return database != null && database.getStoredTables().containsAny(t -> COLUMN_TOOL.referencesGivenTable(column, (ITable)t));
    }

    @Override
    public boolean containsTableWithColumn(IDatabase database, IColumn column) {
        return database != null && database.getStoredTables().containsAny(t -> TABLE_EXAMINER.containsColumn((ITable)t, column));
    }

    @Override
    public boolean containsTableWithName(IDatabase database, String name) {
        return database != null && database.getStoredTables().containsAny(t -> t.hasName(name));
    }

    private boolean canAddGivenTableBecauseOfColumns(IDatabase database, ITable table) {
        return table.getStoredColumns().containsOnly(c -> this.canAddGivenTableBecauseOfGivenColumn(database, table, (IColumn)c));
    }

    private boolean canAddGivenTableBecauseOfGivenColumn(IDatabase database, ITable table, IColumn column) {
        BaseFieldType baseFieldType = COLUMN_TOOL.getBaseFieldType(column);
        return switch (baseFieldType) {
            case BaseFieldType.BASE_VALUE_FIELD -> true;
            case BaseFieldType.BASE_REFERENCE -> this.canAddGivenTableBecauseOfGivenReferenceColumn(database, table, column);
            case BaseFieldType.BASE_BACK_REFERENCE -> true;
            default -> true;
        };
    }

    private boolean canAddGivenTableBecauseOfGivenReferenceColumn(IDatabase database, ITable table, IColumn referenceColumn) {
        return this.containsTableReferencedByColumn(database, referenceColumn) || COLUMN_TOOL.referencesGivenTable(referenceColumn, table);
    }
}

