/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.persistence;

import ch.nolix.system.objectdata.expectation.DatabaseExpectationAdder;
import ch.nolix.system.objectdata.modelvalidator.DatabaseValidator;
import ch.nolix.system.objectdata.persistence.DatabaseSaver;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.expectation.IDatabaseExpectationAdder;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.modelvalidator.IDatabaseValidator;
import ch.nolix.systemapi.objectdata.perstistence.IDatabasePersister;
import ch.nolix.systemapi.objectdata.perstistence.IDatabaseSaver;

public final class DatabasePersister
implements IDatabasePersister {
    private static final IDatabaseValidator DATABASE_VALIDATOR = new DatabaseValidator();
    private static final IDatabaseSaver DATABASE_SAVER = new DatabaseSaver();
    private static final IDatabaseExpectationAdder DATABASE_EXPECTATION_ADDER = new DatabaseExpectationAdder();

    @Override
    public void persistDatabaseChanges(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DATABASE_VALIDATOR.assertCanSaveChanges(database);
        dataAndSchemaAdapter.expectSchemaTimestamp(database.getSchemaTimestamp());
        DATABASE_SAVER.saveDatabaseChanges(database, dataAndSchemaAdapter);
        DATABASE_EXPECTATION_ADDER.addExpectationThatNewlyReferencedEntitiesExist(database, dataAndSchemaAdapter);
        dataAndSchemaAdapter.saveChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistDatabaseChangesTransactional(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        Class<DatabasePersister> clazz = DatabasePersister.class;
        synchronized (DatabasePersister.class) {
            this.persistDatabaseChanges(database, dataAndSchemaAdapter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

