/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.fieldvalidator.ReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractBaseReference;
import ch.nolix.system.objectdata.model.BaseBackReferenceUpdater;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.fieldvalidator.IReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IReference;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import ch.nolix.systemapi.objectdata.structure.EntityCache;
import java.util.Optional;

public final class Reference<E extends IEntity>
extends AbstractBaseReference<E>
implements IReference<E> {
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final IReferenceValidator REFERENCE_VALIDATOR = new ReferenceValidator();
    private EntityCache<E> nullableReferencedEntityCache;

    private Reference(IContainer<String> referenceableTableNames) {
        super(referenceableTableNames);
    }

    @SafeVarargs
    public static <T extends IEntity> Reference<T> forEntityTypes(Class<? extends T> ... entityTypes) {
        ContainerView<Class<String>> entityTypesView = ContainerView.forArray(entityTypes);
        IContainer<String> referenceableTableNamesView = entityTypesView.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new Reference(referenceableTableNamesView);
    }

    public static <T extends IEntity> Reference<T> forEntityTypes(IContainer<Class<? extends T>> entityTypes) {
        IContainer<String> referenceableTableNamesView = entityTypes.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new Reference(referenceableTableNamesView);
    }

    public static <T extends IEntity> Reference<T> forReferenceableTableNames(IContainer<String> referenceableTableNames) {
        return new Reference(referenceableTableNames);
    }

    public static <T extends IEntity> Reference<T> forReferenceableTableNames(String ... referenceableTableNames) {
        ContainerView<String> referenceableTableNamesView = ContainerView.forArray(referenceableTableNames);
        return new Reference(referenceableTableNamesView);
    }

    @Override
    public String getReferencedEntityId() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        return this.nullableReferencedEntityCache.entityId();
    }

    @Override
    public String getReferencedTableId() {
        this.retrieveReferencedTableId();
        return this.nullableReferencedEntityCache.nullableTableId();
    }

    @Override
    public String getReferencedTableName() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
        if (referencedEntity != null) {
            return referencedEntity.getParentTableName();
        }
        return this.getStoredReferencedTable().getName();
    }

    @Override
    public IContainer<IBaseBackReference> getStoredBaseBackReferencesWhoReferencesBackThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = this.getStoredReferencedEntity().internalGetStoredFields();
        Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
        if (abstractBackReferenceContainer.isPresent()) {
            IBaseBackReference abstractBackReference = (IBaseBackReference)abstractBackReferenceContainer.get();
            return ImmutableList.withElements(abstractBackReference);
        }
        return ImmutableList.createEmpty();
    }

    @Override
    public E getStoredReferencedEntity() {
        this.retrieveReferencedEntity();
        return (E)((IEntity)this.nullableReferencedEntityCache.nullableEntity());
    }

    @Override
    public ITable<E> getStoredReferencedTable() {
        IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
        if (referencedEntity != null && referencedEntity.belongsToTable()) {
            return (ITable)referencedEntity.getStoredParentTable();
        }
        if (this.belongsToDatabase()) {
            return DATABASE_SEARCHER.getStoredTableById(this.getStoredParentDatabase(), this.getReferencedTableId());
        }
        IDatabase database = (IDatabase)((IEntity)this.nullableReferencedEntityCache.nullableEntity()).getStoredParentDatabase();
        return DATABASE_SEARCHER.getStoredTableById(database, this.getReferencedTableId());
    }

    @Override
    public FieldType getType() {
        return FieldType.REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        String id = (String)nullableValue;
        if (id == null) {
            throw ArgumentIsNullException.forArgumentName("id");
        }
        String tableId = nullableAdditionalValue;
        if (tableId == null) {
            throw ArgumentIsNullException.forArgumentName("table id");
        }
        this.nullableReferencedEntityCache = new EntityCache<Object>(id, tableId, null);
    }

    @Override
    public boolean isEmpty() {
        return this.nullableReferencedEntityCache == null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.containsAny() && !this.getStoredReferencedEntity().belongsToTable();
    }

    @Override
    public void setEntity(Object entity) {
        this.setCastedEntity((IEntity)entity);
    }

    @Override
    public void setEntityById(String id) {
        E entity = this.getStoredReferencedTable().getStoredEntityById(id);
        this.setEntity(entity);
    }

    @Override
    protected void noteInsertIntoDatabase() {
        if (this.containsAny()) {
            String id = this.nullableReferencedEntityCache.entityId();
            IEntity entity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
            String tableName = entity.getParentTableName();
            String tableId = this.getStoredParentEntity().getStoredParentDatabase().getStoredTableByName(tableName).getId();
            this.nullableReferencedEntityCache = new EntityCache<IEntity>(id, tableId, entity);
            this.updateProbableBackReferenceForSetOrAddedEntity(this.getStoredReferencedEntity());
        }
    }

    private void clear() {
        if (this.containsAny()) {
            this.clearWhenContainsAny();
        }
    }

    private void clearWhenContainsAny() {
        this.updateProbableBackReferencingFieldForClear();
        this.updateStateForClear();
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    private Optional<? extends IField> getOptionalPendantReferencingFieldToEntity(E entity) {
        return ENTITY_SEARCHER.getStoredFieldsWhoAreBackReferencedFromEntity((IEntity)entity).getOptionalStoredFirst(rp -> rp.hasName(this.getName()));
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private void retrieveReferencedEntity() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
        if (referencedEntity == null) {
            String referencedEntityId = this.nullableReferencedEntityCache.entityId();
            String referencedTableId = this.nullableReferencedEntityCache.nullableTableId();
            referencedEntity = this.getStoredReferencedTable().getStoredEntityById(referencedEntityId);
            this.nullableReferencedEntityCache = new EntityCache<IEntity>(referencedEntityId, referencedTableId, referencedEntity);
        }
    }

    private void retrieveReferencedTableId() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        String referencedTableId = this.nullableReferencedEntityCache.nullableTableId();
        if (referencedTableId == null) {
            String referencedEntityId = this.nullableReferencedEntityCache.entityId();
            IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
            ITable referencedTable = (ITable)referencedEntity.getStoredParentTable();
            referencedTableId = referencedTable.getId();
            this.nullableReferencedEntityCache = new EntityCache<IEntity>(referencedEntityId, referencedTableId, referencedEntity);
        }
    }

    private void setCastedEntity(E entity) {
        REFERENCE_VALIDATOR.assertCanSetEntity(this, entity);
        this.updatePropableBackReferencingFieldOfEntityForClear(entity);
        this.clear();
        this.updateStateForSetEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForSetEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    private void updatePotentialBaseBackReferenceOfEntityForSetEntity(E entity) {
        BaseReferenceUpdater.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateProbableBackReferencingFieldForClear() {
        String backReferencedEntityId = this.getStoredParentEntity().getId();
        for (IBaseBackReference b : this.getStoredBaseBackReferencesWhoReferencesBackThis()) {
            BaseBackReferenceUpdater.updateBaseBackReferenceForClearBaseReference(b, backReferencedEntityId);
        }
    }

    private void updatePropableBackReferencingFieldOfEntityForClear(E entity) {
        for (IBaseBackReference b : this.getStoredBaseBackReferencesWhoReferencesBackThis()) {
            Optional<IField> pendantReferencingField;
            if (!FIELD_EXAMINER.isForSingleContent(b) || !(pendantReferencingField = this.getOptionalPendantReferencingFieldToEntity(entity)).isPresent()) continue;
            Reference reference = (Reference)pendantReferencingField.get();
            reference.clear();
        }
    }

    private void updateStateForClear() {
        this.nullableReferencedEntityCache = null;
    }

    private void updateStateForSetEntity(E entity) {
        String id = entity.getId();
        this.nullableReferencedEntityCache = new EntityCache<E>(id, null, entity);
    }
}

