/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.middatamodelmapper;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.middatamodelmapper.StringRepresentedFieldDtoMapper;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.EntityDeletionDto;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.middata.model.ValueStringFieldDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IEntityDtoMapper;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IStringRepresentedFieldDtoMapper;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;

public final class EntityDtoMapper
implements IEntityDtoMapper {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IStringRepresentedFieldDtoMapper STRING_REPRESENTED_FIELD_DTO_MAPPER = new StringRepresentedFieldDtoMapper();

    @Override
    public EntityCreationDto mapEntityToEntityCreationDto(IEntity entity) {
        String id = entity.getId();
        IContainer<? extends IField> entityFields = entity.internalGetStoredFields();
        IContainer<ValueStringFieldDto> contentFields = STRING_REPRESENTED_FIELD_DTO_MAPPER.mapFieldsToStringRepresentedFieldDtos(entityFields);
        return new EntityCreationDto(id, contentFields);
    }

    @Override
    public EntityDeletionDto mapEntityToEntityDeletionDto(IEntity entity) {
        String id = entity.getId();
        String saveStamp = entity.getSaveStamp();
        return new EntityDeletionDto(id, saveStamp);
    }

    @Override
    public EntityUpdateDto mapEntityToEntityUpdateDto(IEntity entity) {
        String id = entity.getId();
        String saveStamp = entity.getSaveStamp();
        IContainer<? extends IField> editedFields = ENTITY_SEARCHER.getStoredEditedFields(entity);
        IContainer<ValueStringFieldDto> contentFields = STRING_REPRESENTED_FIELD_DTO_MAPPER.mapFieldsToStringRepresentedFieldDtos(editedFields);
        return new EntityUpdateDto(id, saveStamp, contentFields);
    }
}

