/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.schemawriter;

import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.nodemidschema.nodemapper.ColumnNodeMapper;
import ch.nolix.system.nodemidschema.nodemapper.TableNodeMapper;
import ch.nolix.system.nodemidschema.nodesearcher.ColumnNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabaseNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabasePropertiesNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.TableNodeSearcher;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.nodemidschema.nodemapper.IColumnNodeMapper;
import ch.nolix.systemapi.nodemidschema.nodemapper.ITableNodeMapper;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IColumnNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabaseNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.ITableNodeSearcher;
import ch.nolix.systemapi.time.moment.ITime;

public final class SchemaWriterActionProvider {
    private static final IDatabaseNodeSearcher DATABASE_NODE_SEARCHER = new DatabaseNodeSearcher();
    private static final IDatabasePropertiesNodeSearcher DATABASE_PROPERTIES_NODE_SEARCHER = new DatabasePropertiesNodeSearcher();
    private static final ITableNodeSearcher TABLE_NODE_SEARCHER = new TableNodeSearcher();
    private static final IColumnNodeSearcher COLUMN_NODE_SEARCHER = new ColumnNodeSearcher();
    private static final ITableNodeMapper TABLE_NODE_MAPPER = new TableNodeMapper();
    private static final IColumnNodeMapper COLUMN_NODE_MAPPER = new ColumnNodeMapper();

    private SchemaWriterActionProvider() {
    }

    public static void addColumn(IMutableNode<?> nodeDatabase, TableIdentification table, ColumnDto column) {
        String tableName = table.tableName();
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        tableNode.addChildNode(COLUMN_NODE_MAPPER.mapColumnDtoToColumnNode(column), new INode[0]);
    }

    public static void addTable(IMutableNode<?> nodeDatabase, TableDto table) {
        nodeDatabase.addChildNode(TABLE_NODE_MAPPER.mapTableDtoToNode(table), new INode[0]);
    }

    public static void deleteColumn(IMutableNode<?> nodeDatabase, TableIdentification table, String columnName) {
        String tableId = table.tableId();
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableIdFromNodeDatabase(nodeDatabase, tableId);
        tableNode.removeFirstChildNodeThat(a -> a.hasHeader("Column") && ((IMutableNode)COLUMN_NODE_SEARCHER.getStoredNameNodeFromColumnNode((IMutableNode)a).getStoredSingleChildNode()).hasHeader(columnName));
    }

    public static void deleteTable(IMutableNode<?> nodeDatabase, String tableName) {
        nodeDatabase.removeFirstChildNodeThat(a -> a.hasHeader("Table") && ((IMutableNode)TABLE_NODE_SEARCHER.getStoredNameNodeFromTableNode((IMutableNode)a).getStoredSingleChildNode()).hasHeader(tableName));
    }

    public static void renameColumn(IMutableNode<?> nodeDatabase, String tableName, String columnName, String newColumnName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> columnNode = TABLE_NODE_SEARCHER.getStoredColumnNodeFromTableNodeByColumnName(tableNode, columnName);
        IMutableNode<?> headerNode = COLUMN_NODE_SEARCHER.getStoredNameNodeFromColumnNode(columnNode);
        headerNode.setHeader(newColumnName);
    }

    public static void renameTable(IMutableNode<?> nodeDatabase, String tableName, String newTableName) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> nameNode = TABLE_NODE_SEARCHER.getStoredNameNodeFromTableNode(tableNode);
        ((IMutableNode)nameNode.getStoredSingleChildNode()).setHeader(newTableName);
    }

    public static void setColumnModel(IMutableNode<?> nodeDatabase, TableIdentification table, ColumnIdentification column, FieldType fieldType, DataType dataType, IContainer<String> referenceableTableIds, IContainer<String> backReferenceableColumnIds) {
        String tableId = table.tableId();
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableIdFromNodeDatabase(nodeDatabase, tableId);
        String columnId = column.columnId();
        IMutableNode<?> columnNode = TABLE_NODE_SEARCHER.getStoredColumnNodeFromTableNodeByColumnId(tableNode, columnId);
        IMutableNode<?> fieldTypeNode = COLUMN_NODE_SEARCHER.getStoredFieldTypeNodeFromColumnNode(columnNode);
        ((IMutableNode)fieldTypeNode.getStoredSingleChildNode()).setHeader(fieldType.name());
        IMutableNode<?> dataTypeNode = COLUMN_NODE_SEARCHER.getStoredDataTypeNodeFromColumnNode(columnNode);
        ((IMutableNode)dataTypeNode.getStoredSingleChildNode()).setHeader(dataType.name());
        IContainer<Node> referenceablteTableIdsNodesView = referenceableTableIds.getViewOf(Node::withHeader);
        IMutableNode<?> referenceablteTableIdsNode = COLUMN_NODE_SEARCHER.getStoredReferenceableTableIdsNodeFromColumnNode(columnNode);
        referenceablteTableIdsNode.setChildNodes(referenceablteTableIdsNodesView);
        IContainer<Node> backReferenceableColumnIdNodes = backReferenceableColumnIds.to(Node::withHeader);
        IMutableNode<?> backReferenceableColumnIdsNode = COLUMN_NODE_SEARCHER.getStoredBackReferenceableColumnIdsNodeFromColumnNode(columnNode);
        backReferenceableColumnIdsNode.setChildNodes(backReferenceableColumnIdNodes);
    }

    public static void setSchemaTimestamp(IMutableNode<?> nodeDatabase, ITime schemaTimestamp) {
        IMutableNode<?> databasePropertiesNode = DATABASE_NODE_SEARCHER.getStoredDatabasePropertiesNodeFromNodeDatabase(nodeDatabase);
        IMutableNode<?> schemaTimestampNode = DATABASE_PROPERTIES_NODE_SEARCHER.getStoredSchemaTimestampNodeFromDatabasePropertiesNode(databasePropertiesNode);
        ((IMutableNode)schemaTimestampNode.getStoredSingleChildNode()).setHeader(schemaTimestamp.getSpecification().getSingleChildNodeHeader());
    }
}

