/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.datareader;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.midschemaview.modelsearcher.DatabaseViewSearcher;
import ch.nolix.system.nodemiddata.datareader.InternalDataReader;
import ch.nolix.systemapi.middata.adapter.IDataReader;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.DatabaseViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.IDatabaseViewSearcher;
import ch.nolix.systemapi.time.moment.ITime;

public final class DataReader
implements IDataReader {
    private static final IDatabaseViewSearcher DATABASE_VIEW_SEARCHER = new DatabaseViewSearcher();
    private final ICloseController closeController = CloseController.forElement(this);
    private final DatabaseViewDto databaseView;
    private final InternalDataReader internalDataReader;

    private DataReader(IMutableNode<?> nodeDatabase, DatabaseViewDto databaseView) {
        Validator.assertThat(databaseView).thatIsNamed("database view").isNotNull();
        this.databaseView = databaseView;
        this.internalDataReader = new InternalDataReader(nodeDatabase);
    }

    public static DataReader forNodeDatabaseAndDatabaseView(IMutableNode<?> nodeDatabase, DatabaseViewDto databaseView) {
        return new DataReader(nodeDatabase, databaseView);
    }

    @Override
    public String getDatabaseName() {
        return this.internalDataReader.getDatabaseName();
    }

    @Override
    public int getEntityCount(String tableName) {
        return this.internalDataReader.getEntityCount(tableName);
    }

    @Override
    public ITime getSchemaTimestamp() {
        return this.internalDataReader.getSchemaTimestamp();
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public IContainer<String> loadMultiBackReferenceBackReferencedEntityIds(String tableName, String entityId, String multiBackReferenceColumnName) {
        ColumnViewDto multiBackReferenceColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiBackReferenceColumnName);
        return this.internalDataReader.loadMultiBackReferenceBackReferencedEntityIds(tableName, entityId, multiBackReferenceColumnView);
    }

    @Override
    public IContainer<MultiBackReferenceEntryDto> loadMultiBackReferenceEntries(TableIdentification table, String entityId, ColumnIdentification multiBackReferenceColumn) {
        String tableName = table.tableName();
        String multiBackReferenceColumnName = multiBackReferenceColumn.columnName();
        ColumnViewDto multiBackReferenceColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiBackReferenceColumnName);
        return this.internalDataReader.loadMultiBackReferenceEntries(tableName, entityId, multiBackReferenceColumnView);
    }

    @Override
    public IContainer<MultiReferenceEntryDto> loadMultiReferenceEntries(String tableName, String entityId, String multiReferenceColumnName) {
        ColumnViewDto multiReferenceColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiReferenceColumnName);
        return this.internalDataReader.loadMultiReferenceEntries(tableName, entityId, multiReferenceColumnView);
    }

    @Override
    public IContainer<Object> loadMultiValueValues(String tableName, String entityId, String multiValueColumnName) {
        ColumnViewDto columnView = this.getColumnViewByTableNameAndColumnName(tableName, multiValueColumnName);
        return this.internalDataReader.loadMultiValueEntries(tableName, entityId, columnView);
    }

    @Override
    public IContainer<EntityLoadingDto> loadEntities(String tableName) {
        TableViewDto tableView = this.getTableViewByTableName(tableName);
        return this.internalDataReader.loadEntitiesOfTable(tableView);
    }

    @Override
    public EntityLoadingDto loadEntity(String tableName, String entityId) {
        TableViewDto tableView = this.getTableViewByTableName(tableName);
        return this.internalDataReader.loadEntity(tableView, entityId);
    }

    @Override
    public void noteClose() {
    }

    @Override
    public boolean tableContainsEntityWithValueAtColumn(String tableName, String columnName, String value) {
        ColumnViewDto columnView = this.getColumnViewByTableNameAndColumnName(tableName, columnName);
        return this.internalDataReader.tableContainsEntityWithGivenValueAtGivenColumn(tableName, columnView, value);
    }

    @Override
    public boolean tableContainsEntityWithValueAtColumnIgnoringEntities(String tableName, String columnName, String value, IContainer<String> entitiesToIgnoreIds) {
        ColumnViewDto columnView = this.getColumnViewByTableNameAndColumnName(tableName, columnName);
        return this.internalDataReader.tableContainsEntityWithGivenValueAtGivenColumnIgnoringGivenEntities(tableName, columnView, value, entitiesToIgnoreIds);
    }

    @Override
    public boolean tableContainsEntity(String tableName, String entityId) {
        return this.internalDataReader.tableContainsEntityWithGivenId(tableName, entityId);
    }

    private ColumnViewDto getColumnViewByTableNameAndColumnName(String tableName, String columnName) {
        return DATABASE_VIEW_SEARCHER.getColumnViewByTableNameAndColumnName(this.databaseView, tableName, columnName);
    }

    private TableViewDto getTableViewByTableName(String tableName) {
        return DATABASE_VIEW_SEARCHER.getTableViewByTableName(this.databaseView, tableName);
    }
}

