/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.cssmapper;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.system.gui.cssmapper.CssValueMapper;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.gui.background.ImageApplication;
import ch.nolix.systemapi.gui.box.Direction;
import ch.nolix.systemapi.gui.colorgradient.IColorGradient;
import ch.nolix.systemapi.gui.cssmapper.ICssValueMapper;

public final class BackgroundToCssMapperHelper {
    private static final ICssProperty TRANSPARENT_BACKGROUND_CSS_PROPERTY = CssProperty.withNameAndValue("background", "none");
    private static final ICssValueMapper CSS_VALUE_MAPPER = new CssValueMapper();
    public static final ImmutableList<ICssProperty> TRANSPARENT_BACKGROUND_CSS_PROPERTIES = ImmutableList.withElements(TRANSPARENT_BACKGROUND_CSS_PROPERTY);

    private BackgroundToCssMapperHelper() {
    }

    private static String getDegreeCodeOfColorGradient(IColorGradient pColorGradient) {
        return BackgroundToCssMapperHelper.getDegreeOfColorGradient(pColorGradient) + "deg";
    }

    private static int getDegreeOfColorGradient(IColorGradient pColorGradient) {
        return BackgroundToCssMapperHelper.getDegreeOfDirection(pColorGradient.getDirection());
    }

    private static int getDegreeOfDirection(Direction direction) {
        return switch (direction) {
            case Direction.VERTICAL -> 180;
            case Direction.HORIZONTAL -> 90;
            case Direction.DIAGONAL_LEFT_DOWN -> 135;
            case Direction.DIAGONAL_LEFT_UP -> 45;
            default -> throw InvalidArgumentException.forArgument((Object)direction);
        };
    }

    public static IContainer<ICssProperty> mapBackgroundToCssPropertiesWhenIsColor(IBackground background) {
        IColor color = background.getColor();
        String colorCssValue = CSS_VALUE_MAPPER.mapColorToCssValue(color);
        CssProperty backgroundCssProperty = CssProperty.withNameAndValue("background", colorCssValue);
        return ImmutableList.withElements(backgroundCssProperty);
    }

    public static IContainer<ICssProperty> mapBackgroundToCssPropertiesWhenIsColorGradient(IBackground background) {
        IColorGradient colorGradient = background.getColorGradient();
        String degreeCode = BackgroundToCssMapperHelper.getDegreeCodeOfColorGradient(colorGradient);
        String color1CssValue = CSS_VALUE_MAPPER.mapColorToCssValue(colorGradient.getColor1());
        String color2CssValue = CSS_VALUE_MAPPER.mapColorToCssValue(colorGradient.getColor2());
        String linearGradientCode = "linear-gradient(" + degreeCode + "," + color1CssValue + "," + color2CssValue + ")";
        CssProperty backgroundCssProperty = CssProperty.withNameAndValue("background", linearGradientCode);
        return ImmutableList.withElements(backgroundCssProperty);
    }

    public static IContainer<ICssProperty> mapBackgroundToCssPropertiesWhenIsImage(IBackground background) {
        IImage image = background.getImage();
        String imageCode = "data:image/jpeg;base64," + image.toBase64Jpg();
        String imageUrl = "url('" + imageCode + "')";
        CssProperty backgroundImageCssProperty = CssProperty.withNameAndValue("background-image", imageUrl);
        ImageApplication imageApplication = background.getImageApplication();
        ICssProperty backgroundRepeatCssProperty = BackgroundToCssMapperHelper.mapImageApplicationToBackgroundRepeatCssProperty(imageApplication);
        return ImmutableList.withElements(backgroundImageCssProperty, backgroundRepeatCssProperty);
    }

    public static ICssProperty mapImageApplicationToBackgroundRepeatCssProperty(ImageApplication imageApplication) {
        return switch (imageApplication) {
            case ImageApplication.SCALE_TO_FRAME -> CssProperty.withNameAndValue("background-size", "100% 100%");
            case ImageApplication.REPEAT -> CssProperty.withNameAndValue("background-repeat", "repeat");
            default -> throw InvalidArgumentException.forArgument((Object)imageApplication);
        };
    }
}

