/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.background;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.image.Image;
import ch.nolix.system.gui.colorgradient.ColorGradient;
import ch.nolix.system.gui.cssmapper.CssPropertyMapper;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.gui.background.BackgroundType;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.gui.background.ImageApplication;
import ch.nolix.systemapi.gui.colorgradient.IColorGradient;
import ch.nolix.systemapi.gui.cssmapper.ICssPropertyMapper;

public final class Background
extends AbstractElement
implements IBackground {
    public static final Background TRANSPARENT_BACKGROUND = new Background();
    public static final ImageApplication DEFAULT_IMAGE_APPLICATION = ImageApplication.SCALE_TO_FRAME;
    private static final String COLOR_HEADER = "Color";
    private static final String COLOR_GRADIENT_HEADER = "ColorGradient";
    private static final String IMAGE_HEADER = "Image";
    private static final String TRANSPARENCY_HEADER = "Transparency";
    private static final ICssPropertyMapper CSS_PROPERTY_MAPPER = new CssPropertyMapper();
    private final IColor color;
    private final IColorGradient colorGradient;
    private final IImage image;
    private final ImageApplication imageApplication;

    private Background() {
        this.color = null;
        this.colorGradient = null;
        this.image = null;
        this.imageApplication = null;
    }

    private Background(IColor color) {
        Validator.assertThat(color).thatIsNamed(IColor.class).isNotNull();
        this.color = color;
        this.colorGradient = null;
        this.image = null;
        this.imageApplication = null;
    }

    private Background(IColorGradient colorGradient) {
        Validator.assertThat(colorGradient).thatIsNamed(IColorGradient.class).isNotNull();
        this.color = null;
        this.colorGradient = colorGradient;
        this.image = null;
        this.imageApplication = null;
    }

    private Background(IImage image, ImageApplication imageApplication) {
        Validator.assertThat(image).thatIsNamed(IImage.class).isNotNull();
        Validator.assertThat(imageApplication).thatIsNamed(ImageApplication.class).isNotNull();
        this.color = null;
        this.colorGradient = null;
        this.image = image;
        this.imageApplication = imageApplication;
    }

    public static Background fromSpecification(INode<?> specification) {
        Object childNode = specification.getStoredFirstChildNode();
        return switch (childNode.getHeader()) {
            case COLOR_HEADER -> Background.withColor(Color.fromSpecification(childNode));
            case COLOR_GRADIENT_HEADER -> Background.withColorGradient(ColorGradient.fromSpecification(childNode));
            case IMAGE_HEADER -> Background.withImageAndImageApplication(Image.fromSpecification(specification.getStoredChildNodeAtOneBasedIndex(1)), ImageApplication.fromSpecification(specification.getStoredChildNodeAtOneBasedIndex(2)));
            case TRANSPARENCY_HEADER -> TRANSPARENT_BACKGROUND;
            default -> throw Background.createExceptionForSpecificationDoesNotSpecifyBackground(specification);
        };
    }

    public static Background withColor(IColor color) {
        return new Background(color);
    }

    public static Background withColorGradient(IColorGradient colorGradient) {
        return new Background(colorGradient);
    }

    public static Background withImage(IImage image) {
        return Background.withImageAndImageApplication(image, DEFAULT_IMAGE_APPLICATION);
    }

    public static Background withImageAndImageApplication(IImage image, ImageApplication imageApplication) {
        return new Background(image, imageApplication);
    }

    private static UnrepresentingArgumentException createExceptionForSpecificationDoesNotSpecifyBackground(INode<?> specification) {
        return UnrepresentingArgumentException.forArgumentAndArgumentNameAndType(specification, "specification", Background.class);
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return switch (this.getType()) {
            case BackgroundType.COLOR -> LinkedList.withElement(this.getColor().getSpecification(), new INode[0]);
            case BackgroundType.COLOR_GRADIENT -> LinkedList.withElement(this.getColorGradient().getSpecification(), new INode[0]);
            case BackgroundType.IMAGE -> LinkedList.withElement(this.getImage().getSpecification(), Node.fromEnum(this.getImageApplication()));
            case BackgroundType.TRANSPARENCY -> LinkedList.withElement(Node.withHeader(TRANSPARENCY_HEADER), new INode[0]);
            default -> throw InvalidArgumentException.forArgument(this);
        };
    }

    @Override
    public IColor getColor() {
        this.assertIsColor();
        return this.color;
    }

    @Override
    public IColorGradient getColorGradient() {
        this.assertIsColorGradient();
        return this.colorGradient;
    }

    @Override
    public IImage getImage() {
        this.assertIsImage();
        return this.image;
    }

    @Override
    public ImageApplication getImageApplication() {
        this.assertIsImage();
        return this.imageApplication;
    }

    @Override
    public BackgroundType getType() {
        if (this.isColor()) {
            return BackgroundType.COLOR;
        }
        if (this.isColorGradient()) {
            return BackgroundType.COLOR_GRADIENT;
        }
        if (this.isImage()) {
            return BackgroundType.IMAGE;
        }
        return BackgroundType.TRANSPARENCY;
    }

    public boolean isColor() {
        return this.color != null;
    }

    public boolean isColorGradient() {
        return this.colorGradient != null;
    }

    public boolean isImage() {
        return this.image != null;
    }

    public boolean isTransparent() {
        return !this.isColor() && !this.isColorGradient() && !this.isImage();
    }

    @Override
    public IContainer<ICssProperty> toCssProperties() {
        return CSS_PROPERTY_MAPPER.mapBackgroundToCssProperties(this);
    }

    private void assertIsColor() {
        if (!this.isColor()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeType(this, IColor.class);
        }
    }

    private void assertIsColorGradient() {
        if (!this.isColorGradient()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeType(this, IColorGradient.class);
        }
    }

    private void assertIsImage() {
        if (!this.isImage()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeType(this, IImage.class);
        }
    }
}

