/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.multistateconfiguration;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.systemapi.element.multistateconfiguration.ValueStoringState;

public final class StateProperty<V> {
    private boolean hasValueOrDefinesEmpty;
    private V value;

    private StateProperty() {
    }

    public static <V2> StateProperty<V2> createUndefinedStateProperty() {
        return new StateProperty();
    }

    public ValueStoringState getAssignmentType() {
        if (!this.hasValueOrDefinesEmpty()) {
            return ValueStoringState.FORWARDING;
        }
        if (!this.hasValue()) {
            return ValueStoringState.DEFINING_EMPTY;
        }
        return ValueStoringState.STORING_VALUE;
    }

    public V getValue() {
        if (!this.hasValueOrDefinesEmpty || this.value == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "value");
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasValueOrDefinesEmpty() {
        return this.hasValueOrDefinesEmpty;
    }

    public void setEmpty() {
        this.hasValueOrDefinesEmpty = true;
        this.value = null;
    }

    public void setForwarding() {
        this.hasValueOrDefinesEmpty = false;
        this.value = null;
    }

    public void setValue(V value) {
        if (value == null) {
            throw ArgumentIsNullException.forArgumentName("value");
        }
        this.hasValueOrDefinesEmpty = true;
        this.value = value;
    }
}

