/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.environment.runningjar.RunningJar;
import ch.nolix.core.errorcontrol.validator.Validator;

record ServerHttpMessage(String serverIP, int serverPort) {
    private static final String REQUIRE_JS_SCRIPT = RunningJar.getResource("script/require_js.js");
    private static final String NOLIX_SCRIPT = RunningJar.getResource("script/nolix.js");

    public ServerHttpMessage {
        Validator.assertThat(serverIP).thatIsNamed("server IP").isNotBlank();
        Validator.assertThat(serverPort).thatIsNamed("server port").isBetween(0, 65535);
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public String getServerIpInQuotes() {
        return "'" + this.getServerIP() + "'";
    }

    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public String toString() {
        return "HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\n\r\n<!DOCTYPE html>\n<html>\n<head>\n<link id=\"icon\" rel=\"icon\" href=\"data:,\">\n<script>\n" + REQUIRE_JS_SCRIPT + "</script>\n<script>\n" + NOLIX_SCRIPT + "</script>\n" + this.getMainScript() + "<title\n>Nolix\n</title>\n</head>\n<body>\n</body>\n</html>\r\n";
    }

    private String getMainScript() {
        return "<script>\nrequire(['System/Application/WebApplication/FrontendWebClient'], function (FrontendWebClient_) {var client = FrontendWebClient_.FrontendWebClient.toIpAndPortAndApplicationFromURL(" + this.getServerIpInQuotes() + ", " + this.getServerPort() + ");});\n</script>\n";
    }
}

