/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.environment.localcomputer.LocalComputer;
import ch.nolix.core.net.target.ServerTarget;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.net.server.ISinglePortServer;
import ch.nolix.coreapi.net.target.IServerTarget;
import ch.nolix.system.application.main.AbstractServer;
import ch.nolix.system.application.main.Application;
import ch.nolix.system.application.main.ServerHttpMessage;
import ch.nolix.system.application.main.ServerSlot;
import ch.nolix.systemapi.application.main.IApplication;

public final class Server
extends AbstractServer<Server>
implements ISinglePortServer {
    private static final SecurityMode SECURITY_MODE_FOR_CONNECTIONS = SecurityMode.NONE;
    private ch.nolix.core.net.endpoint3.Server internalServer;

    private Server(int port) {
        this.internalServer = ch.nolix.core.net.endpoint3.Server.forPortAndHttpMessage(port, new ServerHttpMessage(this.getIp(), port).toString());
        this.createCloseDependencyTo(this.internalServer);
    }

    public static Server forHttpPort() {
        return Server.forPort(80);
    }

    public static Server forPort(int port) {
        return new Server(port);
    }

    @Override
    public IServerTarget asTarget() {
        return ServerTarget.forIpOrDomainAndPortAndSecurityModeForConnections(this.getIp(), this.getPort(), SECURITY_MODE_FOR_CONNECTIONS);
    }

    @Override
    public String getIp() {
        return LocalComputer.getLanIp();
    }

    @Override
    public int getPort() {
        return this.internalServer.getPort();
    }

    @Override
    public SecurityMode getSecurityMode() {
        return this.internalServer.getSecurityMode();
    }

    @Override
    protected Server asConcrete() {
        return this;
    }

    @Override
    protected void noteAddedApplication(Application<?, ?> application) {
        this.internalServer.addSlot(new ServerSlot(application.getUrlInstanceName(), this));
    }

    @Override
    protected void noteAddedDefaultApplication(Application<?, ?> defaultApplication) {
        this.internalServer.addDefaultSlot(new ServerSlot(defaultApplication.getUrlInstanceName(), this));
    }

    @Override
    protected void noteRemovedApplication(IApplication<?, ?> application) {
        this.internalServer.removeSlotByName(application.getUrlInstanceName());
    }
}

