/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.component.applicationcomponent.IClientComponent;
import ch.nolix.coreapi.programcontrol.trigger.IRefreshableSubscriber;
import ch.nolix.system.application.main.AbstractBackendClient;

public abstract class AbstractSession<C extends AbstractBackendClient<C, S>, S>
implements IClientComponent<C>,
IRefreshableSubscriber {
    private C memberParentClient;
    private Object memberResult;

    @Override
    public final boolean belongsToClient() {
        return this.memberParentClient != null;
    }

    public final String getApplicationName() {
        return ((AbstractBackendClient)this.getStoredParentClient()).getApplicationName();
    }

    public final S getStoredApplicationService() {
        return ((AbstractBackendClient)this.getStoredParentClient()).getStoredApplicationService();
    }

    @Override
    public final C getStoredParentClient() {
        this.assertBelongsToClient();
        return this.memberParentClient;
    }

    public final boolean hasParentSession() {
        return ((AbstractBackendClient)this.getStoredParentClient()).internalGetSessionStackSize() > 1;
    }

    @Override
    public final boolean isAlive() {
        return this.memberParentClient != null && this.memberParentClient.isOpen();
    }

    public final void pop() {
        ((AbstractBackendClient)this.getStoredParentClient()).internalPopCurrentSession();
    }

    public final void pop(Object result) {
        ((AbstractBackendClient)this.getStoredParentClient()).internalPopCurrentSessionAndForwardGivenResult(result);
    }

    public final void push(AbstractSession<C, S> session) {
        ((AbstractBackendClient)this.getStoredParentClient()).internalPush(session);
    }

    public final <R> R pushAndGetResult(AbstractSession<C, S> session) {
        return ((AbstractBackendClient)this.getStoredParentClient()).internalPushAndGetResult(session);
    }

    public final void setNext(AbstractSession<C, S> session) {
        ((AbstractBackendClient)this.getStoredParentClient()).internalSetCurrentSession(session);
    }

    protected abstract void fullInitialize();

    protected abstract Class<?> getClientClass();

    final Object internalGetStoredResult() {
        if (this.memberResult == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "result");
        }
        return this.memberResult;
    }

    final void internalRemoveParentClient() {
        this.memberParentClient = null;
    }

    final void internalSetParentClient(C parentClient) {
        Validator.assertThat(parentClient).thatIsNamed("parent client").isNotNull();
        this.assertDoesNotBelongToClient();
        this.memberParentClient = parentClient;
    }

    final void internalSetResult(Object result) {
        Validator.assertThat(result).thatIsNamed("result").isNotNull();
        this.memberResult = result;
    }

    private void assertBelongsToClient() {
        if (!this.belongsToClient()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not belong to a client");
        }
    }

    private void assertDoesNotBelongToClient() {
        if (this.belongsToClient()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "belongs to a client");
        }
    }
}

