/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.reflection.reflectiontool;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.reflection.reflectionexaminer.FieldExaminer;
import ch.nolix.core.reflection.reflectiontool.ConstructorTool;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.reflection.reflectionexaminer.IFieldExaminer;
import ch.nolix.coreapi.reflection.reflectiontool.IClassTool;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public final class ClassTool
implements IClassTool {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final ConstructorTool CONSTRUCTOR_TOOL = new ConstructorTool();

    @Override
    public <T> T createInstanceFromDefaultConstructorOfClass(Class<T> paramClass) {
        return CONSTRUCTOR_TOOL.createInstanceFromDefaultConstructor(this.getDefaultConstructorOfClass(paramClass));
    }

    @Override
    public <T> Constructor<T> getDefaultConstructorOfClass(Class<T> paramClass) {
        try {
            Constructor<T> defaultConstructor = paramClass.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw WrapperException.forError(noSuchMethodException);
        }
    }

    @Override
    public IContainer<Object> getStoredPublicStaticFieldValuesOfClass(Class<?> paramClass) {
        LinkedList<Object> publicStaticFields = LinkedList.createEmpty();
        Field[] fieldArray = paramClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (FIELD_EXAMINER.isStatic(f) && ReflectionTool.isPublic(f)) {
                try {
                    publicStaticFields.addAtEnd(f.get(null));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw WrapperException.forError(illegalAccessException);
                }
            }
            ++n2;
        }
        return publicStaticFields;
    }
}

