/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.process;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.programcontrol.process.IUpdaterCollector;
import java.util.function.Consumer;

public final class UpdaterCollector<O>
implements IUpdaterCollector<O> {
    private final ILinkedList<Consumer<O>> memberUpdaters = LinkedList.createEmpty();

    @Override
    public void addUpdater(Consumer<O> updater) {
        this.memberUpdaters.addAtEnd(updater);
    }

    @Override
    public void addUpdaters(IContainer<Consumer<O>> updaters) {
        this.memberUpdaters.addAtEnd(updaters);
    }

    @Override
    public void clear() {
        this.memberUpdaters.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.memberUpdaters.isEmpty();
    }

    @Override
    public void updateObjectAndClear(O object) {
        Validator.assertThat(object).thatIsNamed(Object.class).isNotNull();
        this.updateObjectAndClearWhenObjectIsNotNull(object);
    }

    private void updateObjectAndClearWhenObjectIsNotNull(O object) {
        try {
            this.memberUpdaters.forEach(u -> u.accept(object));
        }
        finally {
            this.clear();
        }
    }
}

