/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.validator.ExtendedArgumentMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedBigDecimalMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedBitMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedByteMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedDoubleMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedIterableMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedLongMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedMethodMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedOptionalMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedStringMediator;
import ch.nolix.core.errorcontrol.validator.ExtendedTypeMediator;
import ch.nolix.core.errorcontrol.validator.MultiArgumentMediator;
import ch.nolix.core.errorcontrol.validator.MultiDoubleMediator;
import ch.nolix.core.errorcontrol.validator.MultiLongMediator;
import ch.nolix.core.errorcontrol.validator.MultiStringMediator;
import ch.nolix.core.independent.arraytool.ArrayTool;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Optional;

public final class Validator {
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();

    private Validator() {
    }

    public static <A> ExtendedArgumentMediator<A> assertThat(A argument) {
        return new ExtendedArgumentMediator<A>(argument);
    }

    public static ExtendedBigDecimalMediator assertThat(BigDecimal argument) {
        return new ExtendedBigDecimalMediator(argument);
    }

    public static ExtendedByteMediator assertThat(byte argument) {
        return new ExtendedByteMediator(argument);
    }

    public static ExtendedIterableMediator<Byte> assertThat(byte[] argument) {
        return new ExtendedIterableMediator<Byte>(ARRAY_TOOL.createIterable(argument));
    }

    public static <T> ExtendedTypeMediator<T> assertThat(Class<T> argument) {
        return ExtendedTypeMediator.forArgument(argument);
    }

    public static ExtendedDoubleMediator assertThat(double argument) {
        return new ExtendedDoubleMediator(argument);
    }

    public static ExtendedIterableMediator<Double> assertThat(double[] argument) {
        if (argument == null) {
            return new ExtendedIterableMediator<Double>(null);
        }
        return new ExtendedIterableMediator<Double>(ARRAY_TOOL.createIterable(argument));
    }

    public static ExtendedLongMediator assertThat(int argument) {
        return ExtendedLongMediator.forArgument(argument);
    }

    public static ExtendedIterableMediator<Long> assertThat(int[] argument) {
        if (argument == null) {
            return new ExtendedIterableMediator<Long>(null);
        }
        return new ExtendedIterableMediator<Long>(ARRAY_TOOL.createIterable(argument));
    }

    public static <A> ExtendedIterableMediator<A> assertThat(Iterable<A> argument) {
        return new ExtendedIterableMediator<A>(argument);
    }

    public static ExtendedLongMediator assertThat(long argument) {
        return ExtendedLongMediator.forArgument(argument);
    }

    public static ExtendedIterableMediator<Long> assertThat(long[] argument) {
        if (argument == null) {
            return new ExtendedIterableMediator<Long>(null);
        }
        return new ExtendedIterableMediator<Long>(ARRAY_TOOL.createIterable(argument));
    }

    public static ExtendedMethodMediator assertThat(Method argument) {
        return ExtendedMethodMediator.forArgument(argument);
    }

    public static <T> ExtendedOptionalMediator<T> assertThat(Optional<T> argument) {
        return ExtendedOptionalMediator.forArgument(argument);
    }

    public static ExtendedStringMediator assertThat(String argument) {
        return ExtendedStringMediator.forArgument(argument);
    }

    public static ExtendedBitMediator assertThatTheBit(boolean argument) {
        return new ExtendedBitMediator(argument);
    }

    public static MultiDoubleMediator assertThatTheDoubles(Iterable<Double> arguments) {
        return new MultiDoubleMediator(arguments);
    }

    public static <E> MultiArgumentMediator<E> assertThatTheElements(E[] arguments) {
        return new MultiArgumentMediator<E>(arguments);
    }

    public static <E> MultiArgumentMediator<E> assertThatTheElements(Iterable<E> arguments) {
        return new MultiArgumentMediator<E>(arguments);
    }

    public static MultiLongMediator assertThatTheLongs(Iterable<Long> arguments) {
        return new MultiLongMediator(arguments);
    }

    public static MultiStringMediator assertThatTheStrings(Iterable<String> arguments) {
        return new MultiStringMediator(arguments);
    }
}

