/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.ArgumentMediator;
import java.lang.reflect.Modifier;

public class TypeMediator<T>
extends ArgumentMediator<Class<T>> {
    protected TypeMediator(Class<T> argument) {
        super("type", argument);
    }

    protected TypeMediator(String argumentName, Class<T> argument) {
        super(argumentName, argument);
    }

    public static <T2> TypeMediator<T2> forArgument(Class<T2> argument) {
        return new TypeMediator<T2>(argument);
    }

    public static <T2> TypeMediator<T2> forArgumentNameAndArgument(String argumentName, Class<T2> argument) {
        return new TypeMediator<T2>(argumentName, argument);
    }

    public final void isAbstract() {
        this.isNotNull();
        if (!Modifier.isAbstract(((Class)this.getStoredArgument()).getModifiers())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not abstract");
        }
    }

    public final void isClass() {
        this.isNotNull();
        if (((Class)this.getStoredArgument()).isInterface() || ((Class)this.getStoredArgument()).isEnum() || ((Class)this.getStoredArgument()).isArray()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not a class");
        }
    }

    public final void isConcrete() {
        this.isNotNull();
        if (Modifier.isAbstract(((Class)this.getStoredArgument()).getModifiers())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not concrete");
        }
    }

    public final void isEnum() {
        this.isNotNull();
        if (!((Class)this.getStoredArgument()).isEnum()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not an enum");
        }
    }

    public final void isImplementing(Class<?> pInterface) {
        new TypeMediator(pInterface).isInterface();
        this.isClass();
        if (!pInterface.isAssignableFrom((Class)this.getStoredArgument())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not implement " + pInterface.getName());
        }
    }

    public final void isInterface() {
        this.isNotNull();
        if (!((Class)this.getStoredArgument()).isInterface()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not an interface");
        }
    }

    public final void isSubTypeOf(Class<?> type) {
        if (!type.isAssignableFrom((Class)this.getStoredArgument()) || ((Class)this.getStoredArgument()).isAssignableFrom(type)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not a sub type of " + type.getName());
        }
    }

    public final void isSuperTypeOf(Class<?> type) {
        if (!((Class)this.getStoredArgument()).isAssignableFrom(type) || type.isAssignableFrom((Class)this.getStoredArgument())) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "is not a super type of " + type.getName());
        }
    }
}

