/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotContainElementException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonEmptyArgumentException;
import ch.nolix.core.errorcontrol.validator.ArgumentMediator;
import ch.nolix.core.independent.arraytool.ArrayTool;
import ch.nolix.core.independent.iterabletool.IterableExaminer;
import ch.nolix.core.independent.iterabletool.IterableTool;
import ch.nolix.coreapi.independent.iterabletool.IIterableExaminer;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class IterableMediator<E>
extends ArgumentMediator<Iterable<E>> {
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();
    private static final IIterableExaminer ITERABLE_EXAMINER = new IterableExaminer();
    private static final IterableTool ITERABLE_TOOL = new IterableTool();

    public IterableMediator(Iterable<E> argument) {
        super(argument);
    }

    IterableMediator(String argumentName, Iterable<E> argument) {
        super(argumentName, argument);
    }

    public void contains(Object element) {
        if (!ITERABLE_EXAMINER.containsElement((Iterable)this.getStoredArgument(), element)) {
            throw ArgumentDoesNotContainElementException.forArgumentAndArgumentNameAndElement(this.getStoredArgument(), this.getArgumentName(), element);
        }
    }

    public void contains(Predicate<E> condition) {
        if (condition == null) {
            throw ArgumentIsNullException.forArgumentName("condition");
        }
        boolean found = false;
        for (Object e : (Iterable)this.getStoredArgument()) {
            if (!condition.test(e)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this.getStoredArgument(), "does not contain an element that fulfils the given condition");
        }
    }

    public void containsAll(Object[] elements) {
        if (elements == null) {
            throw ArgumentIsNullException.forArgumentName("elements");
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            this.contains(e);
            ++n2;
        }
    }

    public void containsAll(Iterable<Object> elements) {
        if (elements == null) {
            throw ArgumentIsNullException.forArgumentName("elements");
        }
        elements.forEach(this::contains);
    }

    public void containsAsManyElementsAs(Object[] array) {
        if (array == null) {
            throw ArgumentIsNullException.forArgumentName("array");
        }
        this.hasElementCount(array.length);
    }

    public void containsAsManyElementsAs(Iterable<?> iterable) {
        int elementCountOfIterable = ITERABLE_TOOL.getElementCount(iterable);
        this.hasElementCount(elementCountOfIterable);
    }

    public void containsDistinctNonNullElemensOnly() {
        this.containsNonNullElementsOnly();
        Iterable argument = (Iterable)this.getStoredArgument();
        for (Object e : argument) {
            if (!ITERABLE_EXAMINER.containsElementMultipleTimes(argument, e)) continue;
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(argument, this.getArgumentName(), "contains the element '" + String.valueOf(e) + "' multiple times.");
        }
    }

    public void containsEqualing(Object object) {
        this.isNotNull();
        Iterable argument = (Iterable)this.getStoredArgument();
        boolean found = false;
        for (Object e : argument) {
            if (!Objects.equals(e, object)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(argument, "does not contain an element that equals '" + String.valueOf(object) + "'");
        }
    }

    public void containsExactly(Object firstElement, Object ... elements) {
        Object[] allElements = ARRAY_TOOL.createArrayWithElement(firstElement, elements);
        this.hasElementCount(allElements.length);
        this.containsAll(allElements);
    }

    public void containsExactlyEqualing(Object firstElement, Object ... elements) {
        Object[] localElements = ARRAY_TOOL.createArrayWithElement(firstElement, elements);
        this.containsExactlyEqualing(localElements);
    }

    public void containsExactlyEqualing(Object[] elements) {
        this.containsAsManyElementsAs(elements);
        int index = 0;
        for (Object e : (Iterable)this.getStoredArgument()) {
            if (!Objects.equals(e, elements[index])) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(e, index + 1 + "th element", "does not equal the element '" + String.valueOf(elements[index]) + "'");
            }
            ++index;
        }
    }

    public void containsExactlyInSameOrder(E element, E ... elements) {
        E[] localElements = ARRAY_TOOL.createArrayWithElement(element, elements);
        this.containsExactlyInSameOrder(localElements);
    }

    public void containsExactlyInSameOrder(E[] elements) {
        this.containsAsManyElementsAs(elements);
        int index = 0;
        for (Object e : (Iterable)this.getStoredArgument()) {
            if (e != elements[index]) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(e, index + 1 + "th element", "is not the same as the element '" + String.valueOf(elements[index]) + "'");
            }
            ++index;
        }
    }

    public void containsExactlyInSameOrder(Iterable<E> elements) {
        this.containsAsManyElementsAs(elements);
        Iterator<E> iterator = elements.iterator();
        int index = 1;
        for (Object e : (Iterable)this.getStoredArgument()) {
            E element;
            if (e != (element = iterator.next())) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(e, index + "th element", "is not the same as the element '" + String.valueOf(element) + "'");
            }
            ++index;
        }
    }

    public void containsExactlyOneWithStringRepresentation(String stringRepresentation) {
        if (!ITERABLE_EXAMINER.containsExactlyOneWithStringRepresentation((Iterable)this.getStoredArgument(), stringRepresentation)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not contain an element with the String representation '" + stringRepresentation + "'");
        }
    }

    public void containsOnce(Object element) {
        if (!ITERABLE_EXAMINER.containsElementOnce((Iterable)this.getStoredArgument(), element)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not contain the the given element once");
        }
    }

    public void hasElementCount(int elementCount) {
        if (elementCount < 0) {
            throw NegativeArgumentException.forArgumentAndArgumentName(elementCount, "element count");
        }
        this.isNotNull();
        int actualElementCount = 0;
        Iterator iterator = ((Iterable)this.getStoredArgument()).iterator();
        while (iterator.hasNext()) {
            if (++actualElementCount > elementCount) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "contains more than " + elementCount + " elements");
            }
            iterator.next();
        }
        if (actualElementCount < elementCount) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "contains less than " + elementCount + " elements");
        }
    }

    public void hasSameSizeAs(double[] array) {
        if (array == null) {
            throw ArgumentIsNullException.forArgumentName("array");
        }
        this.hasElementCount(array.length);
    }

    public void isEmpty() {
        this.isNotNull();
        if (!ITERABLE_EXAMINER.isEmpty((Iterable)this.getStoredArgument())) {
            throw NonEmptyArgumentException.forArgumentAndArgumentName(this.getStoredArgument(), this.getArgumentName());
        }
    }

    public void isNotEmpty() {
        this.isNotNull();
        if (ITERABLE_EXAMINER.isEmpty((Iterable)this.getStoredArgument())) {
            throw EmptyArgumentException.forArgument(this.getStoredArgument());
        }
    }

    private void containsNonNullElementsOnly() {
        this.isNotNull();
        Iterable argument = (Iterable)this.getStoredArgument();
        int oneBasedndex = 1;
        for (Object e : argument) {
            if (e == null) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(argument, this.getArgumentName(), "contains a null element at the " + oneBasedndex + "th one-based index.");
            }
            ++oneBasedndex;
        }
    }
}

