/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.logging;

import ch.nolix.core.errorcontrol.logging.LogEntry;
import ch.nolix.coreapi.errorcontrol.logging.HarmLevel;

public abstract class AbstractLogHandler {
    public static final HarmLevel DEFAULT_MIN_HARM_LEVEL = HarmLevel.INFO;
    private final HarmLevel minHarmLevel;

    protected AbstractLogHandler() {
        this(DEFAULT_MIN_HARM_LEVEL);
    }

    protected AbstractLogHandler(HarmLevel minHarmLevel) {
        if (minHarmLevel == null) {
            throw new IllegalArgumentException("The given min harm level is null.");
        }
        this.minHarmLevel = minHarmLevel;
    }

    public final HarmLevel getMinHarmLevel() {
        return this.minHarmLevel;
    }

    public final boolean wouldLog(LogEntry logEntry) {
        return logEntry != null && !logEntry.getHarmLevel().isLowerThan(this.getMinHarmLevel());
    }

    protected abstract void log(LogEntry var1);

    final void takeLogEntry(LogEntry logEntry) {
        if (this.wouldLog(logEntry)) {
            this.logSafely(logEntry);
        }
    }

    private void logSafely(LogEntry logEntry) {
        try {
            this.log(logEntry);
        }
        catch (Throwable throwable) {
            System.err.println("An error occured by writing a log entry.");
        }
    }
}

