/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.invalidargumentexception;

import ch.nolix.core.errorcontrol.invalidargumentexception.AbstractInvalidArgumentException;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ArgumentNameDto;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ErrorPredicateDto;

public final class UnrepresentingArgumentException
extends AbstractInvalidArgumentException {
    private static final String DEFAULT_TYPE_NAME = Object.class.getSimpleName();
    private static final String A = "a";
    private static final String AN = "an";

    private UnrepresentingArgumentException(Object argument, Class<?> type) {
        super(argument, new ErrorPredicateDto("does not represent " + UnrepresentingArgumentException.getPronounAndNameOfType(type)));
    }

    private UnrepresentingArgumentException(Object argument, String argumentName, Class<?> type) {
        super(argument, new ArgumentNameDto(argumentName), new ErrorPredicateDto("does not represent " + UnrepresentingArgumentException.getPronounAndNameOfType(type)));
    }

    public static UnrepresentingArgumentException forArgumentAndArgumentNameAndType(Object argument, String argumentName, Class<?> type) {
        return new UnrepresentingArgumentException(argument, argumentName, type);
    }

    public static UnrepresentingArgumentException forArgumentAndType(Object argument, Class<?> type) {
        return new UnrepresentingArgumentException(argument, type);
    }

    private static String getNameOfType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("The given type is null.");
        }
        String name = type.getSimpleName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return DEFAULT_TYPE_NAME;
    }

    private static String getPronounAndNameOfType(Class<?> type) {
        String name = UnrepresentingArgumentException.getNameOfType(type);
        String pronoun = UnrepresentingArgumentException.getPronounForNoun(name);
        return pronoun + " " + name;
    }

    private static String getPronounForNoun(String noun) {
        if (noun == null) {
            throw new IllegalArgumentException("The given noun is null.");
        }
        if (noun.isBlank()) {
            throw new IllegalArgumentException("The given noun is blank.");
        }
        return switch (noun.charAt(0)) {
            case 'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u' -> AN;
            default -> A;
        };
    }
}

