/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.invalidargumentexception;

import ch.nolix.core.errorcontrol.invalidargumentexception.AbstractInvalidArgumentException;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ArgumentNameDto;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ErrorPredicateDto;
import java.math.BigDecimal;

public final class SmallerArgumentException
extends AbstractInvalidArgumentException {
    private SmallerArgumentException(BigDecimal argument, String argumentName, BigDecimal min) {
        super(argument, new ArgumentNameDto(argumentName), new ErrorPredicateDto("is smaller than " + String.valueOf(SmallerArgumentException.getValidatedMinFromMin(min))));
    }

    private SmallerArgumentException(double argument, String argumentName, double min) {
        super(argument, new ArgumentNameDto(argumentName), new ErrorPredicateDto("is smaller than " + min));
    }

    public static SmallerArgumentException forArgumentNameAndArgumentAndLimit(BigDecimal argument, String argumentName, BigDecimal min) {
        return new SmallerArgumentException(argument, argumentName, min);
    }

    public static SmallerArgumentException forArgumentNameAndArgumentAndLimit(double argument, String argumentName, double min) {
        return new SmallerArgumentException(argument, argumentName, min);
    }

    private static BigDecimal getValidatedMinFromMin(BigDecimal min) {
        if (min == null) {
            throw new IllegalArgumentException("The given minimum is null.");
        }
        return min;
    }
}

