/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.filesystem;

import ch.nolix.core.environment.filesystem.FileAccessor;
import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.core.environment.filesystem.FileSystemItemAccessorUnit;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;

public final class FolderAccessor
extends FileSystemItemAccessorUnit {
    public FolderAccessor() {
        super(FileSystemAccessor.getFolderPathOfRunningJarFile());
    }

    public FolderAccessor(String path) {
        super(path);
        if (!FileSystemAccessor.isFolder(path)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("path", path, "is not a folder");
        }
    }

    public boolean containsItem(String relativePath) {
        return FileSystemAccessor.exists(this.getPath() + "/" + relativePath);
    }

    public FileAccessor createFile(String relativePath) {
        return FileSystemAccessor.createFile(this.getPath() + "/" + relativePath);
    }

    public FolderAccessor createFolder(String relativePath) {
        return FileSystemAccessor.createFolder(this.getPath() + "/" + relativePath);
    }

    public void deleteFileSystemItem(String relativePath) {
        FileSystemAccessor.deleteFileSystemItem(this.getPath() + "/" + relativePath);
    }

    public IContainer<FileAccessor> getFileAccessors() {
        return FileSystemAccessor.getFileAccessors(this.getPath());
    }

    public IContainer<FileAccessor> getFileAccessors(String extension) {
        return FileSystemAccessor.getFileAccessors(this.getPath(), extension);
    }

    public IContainer<FileAccessor> getFileAccessorsRecursively(String extension) {
        return this.getFileAccessorsRecursively().getStoredSelected(fa -> fa.hasExtension(extension));
    }

    public ILinkedList<FileAccessor> getFileAccessorsRecursively() {
        return FileSystemAccessor.getFileAccessorsRecursively(this.getPath());
    }

    public IContainer<FileSystemItemAccessorUnit> getFileSystemItemAccessors() {
        return FileSystemAccessor.getFileSystemItemAccessors(this.getPath());
    }

    public FolderAccessor getFolderAccessor(String relativePath) {
        return new FolderAccessor(this.getPath() + "/" + relativePath);
    }

    public void openInFileExplorer() {
        FileSystemAccessor.openInFileExplorer(this.getPath());
    }

    public String readFile(String relativePath) {
        return new FileAccessor(this.getPath() + "/" + relativePath).readFile();
    }
}

