/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.filesystem;

import ch.nolix.core.environment.filesystem.FolderAccessor;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.commontypetool.stringtool.RegularExpressionPatternCatalog;
import java.io.File;

public class FileSystemItemAccessorUnit {
    private final File internalAccessor;

    public FileSystemItemAccessorUnit(String path) {
        this.internalAccessor = new File(path);
        if (!this.internalAccessor.exists()) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("path", path, "is not a file system item");
        }
    }

    public final String getExtension() {
        String[] array = RegularExpressionPatternCatalog.DOT_PATTERN.split(this.getName());
        return "." + array[array.length - 1];
    }

    public final String getName() {
        String[] array = this.getPath().split("/");
        return array[array.length - 1];
    }

    public final FolderAccessor getParentFolderAccessor() {
        return new FolderAccessor(this.internalAccessor.getParent());
    }

    public final String getPath() {
        return this.internalAccessor.getAbsolutePath();
    }

    public final boolean hasExtension(String extension) {
        return this.getExtension().equals(extension);
    }

    public long getSizeInBytes() {
        return this.getInternalAccessor().length();
    }

    public final boolean isFile() {
        return this.getInternalAccessor().isFile();
    }

    public final boolean isFolder() {
        return this.getInternalAccessor().isDirectory();
    }

    public final void openParentFolder() {
        this.getParentFolderAccessor().openInFileExplorer();
    }

    protected final File getInternalAccessor() {
        return this.internalAccessor;
    }
}

