/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.filesystem;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.environment.filesystem.FileAccessor;
import ch.nolix.core.environment.filesystem.FileSystemItemAccessorUnit;
import ch.nolix.core.environment.filesystem.FolderAccessor;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.programcontrol.processproperty.WriteMode;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;

public final class FileSystemAccessor {
    private FileSystemAccessor() {
    }

    public static FolderAccessor getFolderOfRunningJarFile() {
        return new FolderAccessor(FileSystemAccessor.getFolderPathOfRunningJarFile());
    }

    public static String getFolderPathOfRunningJarFile() {
        try {
            return FileSystemAccessor.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException pURISyntaxException) {
            throw WrapperException.forError(pURISyntaxException);
        }
    }

    public static void openInFileExplorer(String path) {
        try {
            Runtime.getRuntime().exec(new String[]{"explorer.exe", "/select,", path});
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public static void openFolderOfRunningJarFileInExplorer() {
        FileSystemAccessor.openInFileExplorer(FileSystemAccessor.getFolderPathOfRunningJarFile());
    }

    public static FileAccessor createFile(String path) {
        return FileSystemAccessor.createFile(path, WriteMode.THROW_EXCEPTION_WHEN_TARGET_EXISTS_ALREADY);
    }

    public static FileAccessor createFile(String path, WriteMode writeMode) {
        Validator.assertThat(path).thatIsNamed("path").isNotBlank();
        try {
            if (!new File(path).createNewFile()) {
                switch (writeMode) {
                    case OVERWRITE_WHEN_TARGET_EXISTS_ALREADY: {
                        FileSystemAccessor.deleteFileSystemItem(path);
                        return FileSystemAccessor.createFile(path);
                    }
                    case SKIP_WHEN_TARGET_EXISTS_ALREADY: {
                        return new FileAccessor(path);
                    }
                    case THROW_EXCEPTION_WHEN_TARGET_EXISTS_ALREADY: {
                        throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("file system item", path, "exists already");
                    }
                }
                throw InvalidArgumentException.forArgument((Object)writeMode);
            }
            return new FileAccessor(path);
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public static FileAccessor createFile(String path, WriteMode writeMode, byte[] content) {
        FileAccessor fileAccessor = FileSystemAccessor.createFile(path, writeMode);
        fileAccessor.overwriteFile(content);
        return fileAccessor;
    }

    public static FileAccessor createFile(String path, WriteMode writeMode, String content) {
        FileAccessor fileAccessor = FileSystemAccessor.createFile(path, writeMode);
        fileAccessor.overwriteFile(content);
        return fileAccessor;
    }

    public static FileAccessor createFile(String path, byte[] content) {
        FileAccessor fileAccessor = FileSystemAccessor.createFile(path);
        fileAccessor.overwriteFile(content);
        return fileAccessor;
    }

    public static FileAccessor createFile(String path, String content) {
        return FileSystemAccessor.createFile(path, WriteMode.THROW_EXCEPTION_WHEN_TARGET_EXISTS_ALREADY, content);
    }

    public static FolderAccessor createFolder(String path) {
        if (FileSystemAccessor.exists(path)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("file system item", path, "exists already");
        }
        new File(path).mkdirs();
        return new FolderAccessor(path);
    }

    public static void deleteFileSystemItem(String path) {
        try {
            Files.delete(Path.of(path, new String[0]));
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public static boolean exists(String path) {
        return new File(path).exists();
    }

    public static IContainer<FileAccessor> getFileAccessors(String path) {
        return ContainerView.forArray(new File(path).listFiles()).getViewOfStoredSelected(File::isFile).to(f -> new FileAccessor(f.getAbsolutePath()));
    }

    public static IContainer<FileAccessor> getFileAccessors(String path, String extension) {
        return FileSystemAccessor.getFileAccessors(path).getStoredSelected(fa -> fa.hasExtension(extension));
    }

    public static ILinkedList<FileAccessor> getFileAccessorsRecursively(String path) {
        LinkedList<FileAccessor> fileAccessors = LinkedList.createEmpty();
        File[] fileArray = new File(path).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                fileAccessors.addAtEnd(new FileAccessor(f.getPath()));
            } else if (f.isDirectory()) {
                fileAccessors.addAtEnd(new FolderAccessor(f.getPath()).getFileAccessorsRecursively());
            } else {
                throw InvalidArgumentException.forArgument(f);
            }
            ++n2;
        }
        return fileAccessors;
    }

    public static IContainer<FileSystemItemAccessorUnit> getFileSystemItemAccessors(String path) {
        return ContainerView.forArray(new File(path).listFiles()).to(f -> new FileSystemItemAccessorUnit(f.getAbsolutePath()));
    }

    public static boolean isFile(String path) {
        return new File(path).isFile();
    }

    public static boolean isFolder(String path) {
        return new File(path).isDirectory();
    }

    public static void overwriteFile(String path, byte[] content) {
        if (FileSystemAccessor.isFolder(path)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(path, "is a folder");
        }
        if (!FileSystemAccessor.isFile(path)) {
            FileSystemAccessor.createFile(path);
        }
        new FileAccessor(path).overwriteFile(content);
    }

    public static void overwriteFile(String path, String content) {
        if (FileSystemAccessor.isFolder(path)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(path, "is a folder");
        }
        if (!FileSystemAccessor.isFile(path)) {
            FileSystemAccessor.createFile(path);
        }
        new FileAccessor(path).overwriteFile(content);
    }

    public static byte[] readFileToBytes(String filePath) {
        return new FileAccessor(filePath).readFileToBytes();
    }

    public static ILinkedList<String> readFileToLines(String path) {
        return new FileAccessor(path).readFileToLines();
    }
}

