/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.filesystem;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.core.environment.filesystem.FileSystemItemAccessorUnit;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.list.ILinkedList;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public final class FileAccessor
extends FileSystemItemAccessorUnit {
    public FileAccessor(String filePath) {
        super(filePath);
        if (!FileSystemAccessor.isFile(filePath)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("file path", filePath, "is not a file");
        }
    }

    public void clearFile() {
        this.overwriteFile("");
    }

    public void overwriteFile(byte[] bytes) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.getInternalAccessor());){
                fileOutputStream.write(bytes);
                fileOutputStream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw WrapperException.forError(exception);
        }
    }

    public void overwriteFile(String content) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter printWriter = new PrintWriter(this.getInternalAccessor(), StandardCharsets.UTF_8);){
                printWriter.print(content.replace("\n", "\r\n"));
                printWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw WrapperException.forError(exception);
        }
    }

    public String readFile() {
        return new String(this.readFileToBytes(), StandardCharsets.UTF_8).replace("\r", "");
    }

    public byte[] readFileToBytes() {
        try {
            return Files.readAllBytes(this.getInternalAccessor().toPath());
        }
        catch (IOException exception) {
            throw WrapperException.forError(exception);
        }
    }

    public ILinkedList<String> readFileToLines() {
        LinkedList<String> lines = LinkedList.createEmpty();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getInternalAccessor(), StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    lines.addAtEnd(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
        return lines;
    }
}

