/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.matrix;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.matrix.Matrix;
import ch.nolix.core.container.matrix.MatrixColumnIterator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class MatrixColumn<E>
extends AbstractExtendedContainer<E> {
    private final Matrix<E> parentMatrix;
    private final int columnIndex;

    MatrixColumn(Matrix<E> parentMatrix, int columnIndex) {
        Validator.assertThat(parentMatrix).thatIsNamed("parent matrix").isNotNull();
        Validator.assertThat(columnIndex).thatIsNamed("column index").isPositive();
        this.parentMatrix = parentMatrix;
        this.columnIndex = columnIndex;
    }

    @Override
    public int getCount() {
        return this.parentMatrix.getRowCount();
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public E getStoredAtOneBasedIndex(int rowIndex) {
        return this.parentMatrix.getStoredAtOneBasedRowIndexAndColumnIndex(rowIndex, this.getColumnIndex());
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return MatrixColumnIterator.forMatrixColumn(this);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

