/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.linkedlist;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import java.util.function.Predicate;

final class LinkedListNode<E> {
    private E memberElement;
    private LinkedListNode<E> nextNode;

    public LinkedListNode(E element) {
        this.setElement(element);
    }

    public boolean contains(Predicate<E> selector) {
        return selector.test(this.getElement());
    }

    public boolean contains(Object element) {
        return this.getElement() == element;
    }

    public E getElement() {
        return this.memberElement;
    }

    public LinkedListNode<E> getNextNode() {
        if (!this.hasNextNode()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next node");
        }
        return this.nextNode;
    }

    public boolean hasNextNode() {
        return this.nextNode != null;
    }

    public void removeNextNode() {
        this.nextNode = null;
    }

    public void setElement(E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.memberElement = element;
    }

    public void setNextNode(LinkedListNode<E> nextNode) {
        Validator.assertThat(nextNode).thatIsNamed("next node").isNotNull();
        this.nextNode = nextNode;
    }

    public void swapElementWithNextNode() {
        if (!this.hasNextNode()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next node");
        }
        E lElement = this.nextNode.getElement();
        this.nextNode.setElement(this.getElement());
        this.setElement(lElement);
    }
}

