/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.immutablelist;

import ch.nolix.core.commontypetool.arraytool.ArrayIterator;
import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.stream.Stream;

public final class ImmutableList<E>
extends AbstractExtendedContainer<E> {
    private static final ImmutableList<Object> EMPTY = new ImmutableList<Object>(new Object[0]);
    private final E[] elements;

    private ImmutableList(E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.elements = new Object[]{element};
    }

    private ImmutableList(E[] elements) {
        Validator.assertThatTheElements(elements).areNotNull();
        this.elements = (Object[])elements.clone();
    }

    private ImmutableList(Iterable<E> elements) {
        int elementCount = ImmutableList.getCountOfIterable(elements);
        this.elements = new Object[elementCount];
        int index = 0;
        for (E e : elements) {
            if (e == null) {
                throw ArgumentIsNullException.forArgumentName(index + 1 + "th element");
            }
            this.elements[index] = e;
            ++index;
        }
    }

    private static <T> int getCountOfIterable(Iterable<T> iterable) {
        int elementCount;
        if (iterable instanceof IContainer) {
            IContainer container = (IContainer)iterable;
            elementCount = container.getCount();
        } else {
            elementCount = IterableTool.getCount(iterable);
        }
        return elementCount;
    }

    public static <T> ImmutableList<T> createEmpty() {
        return EMPTY;
    }

    public static <T> ImmutableList<T> fromArray(T[] array) {
        return new ImmutableList<T>(array);
    }

    public static <T> ImmutableList<T> fromIterable(Iterable<T> iterable) {
        if (iterable instanceof ImmutableList) {
            ImmutableList immutableList = (ImmutableList)iterable;
            return immutableList;
        }
        return new ImmutableList<T>(iterable);
    }

    public static <T> ImmutableList<T> fromStream(Stream<T> stream) {
        Validator.assertThat(stream).thatIsNamed(Stream.class).isNotNull();
        return ImmutableList.fromIterable(stream.toList());
    }

    public static <T> ImmutableList<T> withElement(T element) {
        return new ImmutableList<T>(element);
    }

    @SafeVarargs
    public static <T> ImmutableList<T> withElements(T ... elements) {
        return new ImmutableList<T>(elements);
    }

    @Override
    public int getCount() {
        return this.elements.length;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("1-based index").isBetween(1, this.getCount());
        return this.elements[oneBasedIndex - 1];
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return ArrayIterator.forArray(this.elements);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

