package ch.nolix.coreapi.environment.filesystem;

/**
 * The {@link FileExtensionCatalog} defines common file extensions. Of the
 * {@link FileExtensionCatalog} an instance cannot be created.
 * 
 * @author Silvan Wyss
 * @version 2018-12-16
 */
public final class FileExtensionCatalog {
  public static final String AVI = ".avi";

  public static final String C = ".c";

  public static final String CS = ".cs";

  public static final String CSS = ".css";

  public static final String CSV = ".csv";

  public static final String DOC = ".doc";

  public static final String DOCX = ".docs";

  public static final String EXE = ".exe";

  public static final String FLV = ".flv";

  public static final String H = ".h";

  public static final String HTML = ".html";

  public static final String INI = ".ini";

  public static final String JAVA = ".java";

  public static final String JAVA_CLASS = ".class";

  public static final String JPEG = ".jpeg";

  public static final String JS = ".js";

  public static final String MP3 = ".mp3";

  public static final String MP4 = ".mp4";

  public static final String ODT = ".odt";

  public static final String PDF = ".pdf";

  public static final String PNG = ".png";

  public static final String PPT = ".ppt";

  public static final String PPTX = ".pptx";

  public static final String PY = ".py";

  public static final String RAR = ".rar";

  public static final String TAR = ".tar";

  public static final String TS = ".ts";

  public static final String TXT = ".txt";

  public static final String WAV = ".wav";

  public static final String XML = ".xml";

  /**
   * Prevents that an instance of the {@link FileExtensionCatalog} can be created.
   */
  private FileExtensionCatalog() {
  }
}
